/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.file.FileExchange;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.language.bean.BeanLanguage;
import org.apache.camel.language.simple.SimpleLanguage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileExpressionBuilder {
    private FileExpressionBuilder() {
    }

    public static <E extends FileExchange> Expression<E> fileNameExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                if (((FileExchange)exchange).getFile() == null) {
                    return null;
                }
                return ((FileExchange)exchange).getFile().getName();
            }

            public String toString() {
                return "file:name";
            }
        };
    }

    public static <E extends FileExchange> Expression<E> fileNameNoExtensionExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                if (((FileExchange)exchange).getFile() == null) {
                    return null;
                }
                String name = ((FileExchange)exchange).getFile().getName();
                return name.substring(0, name.lastIndexOf(46));
            }

            public String toString() {
                return "file:name.noext";
            }
        };
    }

    public static <E extends FileExchange> Expression<E> fileParentExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                if (((FileExchange)exchange).getFile() == null) {
                    return null;
                }
                return ((FileExchange)exchange).getFile().getParent();
            }

            public String toString() {
                return "file:parent";
            }
        };
    }

    public static <E extends FileExchange> Expression<E> filePathExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                if (((FileExchange)exchange).getFile() == null) {
                    return null;
                }
                return ((FileExchange)exchange).getFile().getPath();
            }

            public String toString() {
                return "file:path";
            }
        };
    }

    public static <E extends FileExchange> Expression<E> fileAbsoluteExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                if (((FileExchange)exchange).getFile() == null) {
                    return null;
                }
                return ((FileExchange)exchange).getFile().getAbsolutePath();
            }

            public String toString() {
                return "file:absolute";
            }
        };
    }

    public static <E extends FileExchange> Expression<E> fileCanoicalPathExpression() {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                if (((FileExchange)exchange).getFile() == null) {
                    return null;
                }
                try {
                    return ((FileExchange)exchange).getFile().getCanonicalPath();
                }
                catch (IOException e) {
                    throw new RuntimeCamelException("Could not get the canonical path for file: " + ((FileExchange)exchange).getFile(), e);
                }
            }

            public String toString() {
                return "file:canonical.path";
            }
        };
    }

    public static <E extends FileExchange> Expression<E> dateExpression(final String command, final String pattern) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                String key;
                Date date;
                if ("file".equals(command)) {
                    if (((FileExchange)exchange).getFile() == null) {
                        return null;
                    }
                    date = new Date(((FileExchange)exchange).getFile().lastModified());
                } else if ("now".equals(command)) {
                    date = new Date();
                } else if (command.startsWith("header.") || command.startsWith("in.header.")) {
                    key = command.substring(command.lastIndexOf(".") + 1);
                    date = ((DefaultExchange)exchange).getIn().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Could not find java.util.Date object at " + command);
                    }
                } else if (command.startsWith("out.header.")) {
                    key = command.substring(command.lastIndexOf(".") + 1);
                    date = ((DefaultExchange)exchange).getOut().getHeader(key, Date.class);
                    if (date == null) {
                        throw new IllegalArgumentException("Could not find java.util.Date object at " + command);
                    }
                } else {
                    throw new IllegalArgumentException("Command not supported for dateExpression: " + command);
                }
                SimpleDateFormat df = new SimpleDateFormat(pattern);
                return df.format(date);
            }

            public String toString() {
                return "date(" + command + ":" + pattern + ")";
            }
        };
    }

    public static <E extends FileExchange> Expression<E> simpleExpression(final String simple) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return SimpleLanguage.simple(simple).evaluate(exchange);
            }

            public String toString() {
                return "simple(" + simple + ")";
            }
        };
    }

    public static <E extends FileExchange> Expression<E> beanExpression(final String bean) {
        return new Expression<E>(){

            @Override
            public Object evaluate(E exchange) {
                return BeanLanguage.bean(bean).evaluate(exchange);
            }

            public String toString() {
                return "bean(" + bean + ")";
            }
        };
    }
}

