/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.camel.management.Counter;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;

@ManagedResource(description="PerformanceCounter", currencyTimeLimit=15)
public class PerformanceCounter
extends Counter {
    private AtomicLong numCompleted = new AtomicLong(0L);
    private double minProcessingTime = -1.0;
    private double maxProcessingTime;
    private double totalProcessingTime;
    private Date lastExchangeCompletionTime;
    private Date lastExchangeFailureTime;
    private Date firstExchangeCompletionTime;
    private Date firstExchangeFailureTime;

    @ManagedOperation(description="Reset counters")
    public synchronized void reset() {
        super.reset();
        this.numCompleted.set(0L);
        this.minProcessingTime = -1.0;
        this.maxProcessingTime = 0.0;
        this.totalProcessingTime = 0.0;
        this.lastExchangeCompletionTime = null;
        this.lastExchangeFailureTime = null;
        this.firstExchangeCompletionTime = null;
        this.firstExchangeFailureTime = null;
    }

    @ManagedAttribute(description="Number of successful exchanges")
    public long getNumCompleted() throws Exception {
        return this.numCompleted.get();
    }

    @ManagedAttribute(description="Number of failed exchanges")
    public long getNumFailed() throws Exception {
        return this.numExchanges.get() - this.numCompleted.get();
    }

    @ManagedAttribute(description="Min Processing Time [milliseconds]")
    public synchronized double getMinProcessingTimeMillis() throws Exception {
        return this.minProcessingTime;
    }

    @ManagedAttribute(description="Mean Processing Time [milliseconds]")
    public synchronized double getMeanProcessingTimeMillis() throws Exception {
        long count = this.numCompleted.get();
        return count > 0L ? this.totalProcessingTime / (double)count : 0.0;
    }

    @ManagedAttribute(description="Max Processing Time [milliseconds]")
    public synchronized double getMaxProcessingTimeMillis() throws Exception {
        return this.maxProcessingTime;
    }

    @ManagedAttribute(description="Total Processing Time [milliseconds]")
    public synchronized double getTotalProcessingTimeMillis() throws Exception {
        return this.totalProcessingTime;
    }

    @ManagedAttribute(description="Last Exchange Completed Timestamp")
    public synchronized Date getLastExchangeCompletionTime() {
        return this.lastExchangeCompletionTime;
    }

    @ManagedAttribute(description="First Exchange Completed Timestamp")
    public synchronized Date getFirstExchangeCompletionTime() {
        return this.firstExchangeCompletionTime;
    }

    @ManagedAttribute(description="Last Exchange Failed Timestamp")
    public synchronized Date getLastExchangeFailureTime() {
        return this.lastExchangeFailureTime;
    }

    @ManagedAttribute(description="First Exchange Failed Timestamp")
    public synchronized Date getFirstExchangeFailureTime() {
        return this.firstExchangeFailureTime;
    }

    public synchronized void completedExchange(double time) {
        this.increment();
        this.numCompleted.incrementAndGet();
        this.totalProcessingTime += time;
        if (this.minProcessingTime < 0.0 || time < this.minProcessingTime) {
            this.minProcessingTime = time;
        }
        if (time > this.maxProcessingTime) {
            this.maxProcessingTime = time;
        }
        Date timestamp = new Date();
        if (this.firstExchangeCompletionTime == null) {
            this.firstExchangeCompletionTime = timestamp;
        }
        this.lastExchangeCompletionTime = timestamp;
    }

    public synchronized void failedExchange() {
        this.increment();
        Date timestamp = new Date();
        if (this.firstExchangeFailureTime == null) {
            this.firstExchangeFailureTime = timestamp;
        }
        this.lastExchangeFailureTime = timestamp;
    }
}

