/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.processor.RoutingSlip;
import org.apache.camel.spi.RouteContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="routingSlip")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoutingSlipType
extends ProcessorType<ProcessorType> {
    public static final String ROUTING_SLIP_HEADER = "routingSlipHeader";
    public static final String DEFAULT_DELIMITER = ",";
    @XmlAttribute
    private String headerName;
    @XmlAttribute
    private String uriDelimiter;

    public RoutingSlipType() {
        this(ROUTING_SLIP_HEADER, DEFAULT_DELIMITER);
    }

    public RoutingSlipType(String headerName) {
        this(headerName, DEFAULT_DELIMITER);
    }

    public RoutingSlipType(String headerName, String uriDelimiter) {
        this.setHeaderName(headerName);
        this.setUriDelimiter(uriDelimiter);
    }

    public String toString() {
        return "RoutingSlip[ headerName=" + this.getHeaderName() + " uriDelimiter=" + this.getUriDelimiter() + "]";
    }

    @Override
    public String getShortName() {
        return "routingSlip";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        return new RoutingSlip(this.getHeaderName(), this.getUriDelimiter());
    }

    @Override
    public List<ProcessorType<?>> getOutputs() {
        return Collections.EMPTY_LIST;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setUriDelimiter(String uriDelimiter) {
        this.uriDelimiter = uriDelimiter;
    }

    public String getUriDelimiter() {
        return this.uriDelimiter;
    }
}

