/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.Exchange;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;

@XmlType(name="dataFormatType")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DataFormatType
extends IdentifiedType
implements DataFormat {
    @XmlTransient
    private DataFormat dataFormat;
    @XmlTransient
    private String dataFormatTypeName;

    public DataFormatType() {
    }

    public DataFormatType(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    protected DataFormatType(String dataFormatTypeName) {
        this.dataFormatTypeName = dataFormatTypeName;
    }

    public static DataFormat getDataFormat(RouteContext routeContext, DataFormatType type, String ref) {
        if (type == null) {
            ObjectHelper.notNull(ref, "ref or dataFormatType");
            DataFormat dataFormat = routeContext.lookup(ref, DataFormat.class);
            if (dataFormat instanceof DataFormatType) {
                type = (DataFormatType)dataFormat;
            } else {
                return dataFormat;
            }
        }
        return type.getDataFormat(routeContext);
    }

    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        ObjectHelper.notNull(this.dataFormat, "dataFormat");
        this.dataFormat.marshal(exchange, graph, stream);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        ObjectHelper.notNull(this.dataFormat, "dataFormat");
        return this.dataFormat.unmarshal(exchange, stream);
    }

    public DataFormat getDataFormat(RouteContext routeContext) {
        if (this.dataFormat == null) {
            this.dataFormat = this.createDataFormat(routeContext);
            ObjectHelper.notNull(this.dataFormat, "dataFormat");
            this.configureDataFormat(this.dataFormat);
        }
        return this.dataFormat;
    }

    protected DataFormat createDataFormat(RouteContext routeContext) {
        if (this.dataFormatTypeName != null) {
            Class<?> type = ObjectHelper.loadClass(this.dataFormatTypeName, this.getClass().getClassLoader());
            if (type == null) {
                throw new IllegalArgumentException("The class " + this.dataFormatTypeName + " is not on the classpath! Cannot use the dataFormat " + this);
            }
            return (DataFormat)ObjectHelper.newInstance(type);
        }
        return null;
    }

    protected void configureDataFormat(DataFormat dataFormat) {
    }

    protected void setProperty(Object bean, String name, Object value) {
        try {
            IntrospectionSupport.setProperty(bean, name, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to set property " + name + " on " + bean + ". Reason: " + e, e);
        }
    }
}

