/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.model.ExceptionType;
import org.apache.camel.processor.ErrorHandler;
import org.apache.camel.processor.exceptionpolicy.DefaultExceptionPolicyStrategy;
import org.apache.camel.processor.exceptionpolicy.ExceptionPolicyStrategy;

public abstract class ErrorHandlerSupport
extends ServiceSupport
implements ErrorHandler {
    private Map<Class, ExceptionType> exceptionPolicies = new LinkedHashMap<Class, ExceptionType>();
    private ExceptionPolicyStrategy exceptionPolicy = ErrorHandlerSupport.createDefaultExceptionPolicyStrategy();

    public void addExceptionPolicy(ExceptionType exception) {
        Processor processor = exception.getErrorHandler();
        this.addChildService(processor);
        List<Class> list = exception.getExceptionClasses();
        for (Class exceptionType : list) {
            this.exceptionPolicies.put(exceptionType, exception);
        }
    }

    protected boolean customProcessorForException(Exchange exchange, Throwable exception) throws Exception {
        Processor processor;
        ExceptionType policy = this.getExceptionPolicy(exchange, exception);
        if (policy != null && (processor = policy.getErrorHandler()) != null) {
            processor.process(exchange);
            return true;
        }
        return false;
    }

    protected ExceptionType getExceptionPolicy(Exchange exchange, Throwable exception) {
        if (this.exceptionPolicy == null) {
            throw new IllegalStateException("The exception policy has not been set");
        }
        return this.exceptionPolicy.getExceptionPolicy(this.exceptionPolicies, exchange, exception);
    }

    public void setExceptionPolicy(ExceptionPolicyStrategy exceptionPolicy) {
        this.exceptionPolicy = exceptionPolicy;
    }

    public static ExceptionPolicyStrategy createDefaultExceptionPolicyStrategy() {
        return new DefaultExceptionPolicyStrategy();
    }
}

