/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.converter.CollectionConverter;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastProcessor
extends ServiceSupport
implements Processor {
    private Collection<Processor> processors;
    private AggregationStrategy aggregationStrategy;
    private boolean isParallelProcessing;
    private ThreadPoolExecutor executor;
    private final AtomicBoolean shutdown = new AtomicBoolean(true);

    public MulticastProcessor(Collection<Processor> processors) {
        this(processors, null);
    }

    public MulticastProcessor(Collection<Processor> processors, AggregationStrategy aggregationStrategy) {
        this(processors, aggregationStrategy, false, null);
    }

    public MulticastProcessor(Collection<Processor> processors, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ThreadPoolExecutor executor) {
        ObjectHelper.notNull(processors, "processors");
        this.processors = processors;
        this.aggregationStrategy = aggregationStrategy;
        this.isParallelProcessing = parallelProcessing;
        if (this.isParallelProcessing) {
            this.executor = executor != null ? executor : new ThreadPoolExecutor(processors.size(), processors.size(), 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(processors.size()));
        }
    }

    public static <E extends Exchange> Collection<Processor> toProducers(Collection<Endpoint> endpoints) throws Exception {
        ArrayList<Processor> answer = new ArrayList<Processor>();
        for (Endpoint endpoint : endpoints) {
            answer.add(endpoint.createProducer());
        }
        return answer;
    }

    public String toString() {
        return "Multicast" + this.getProcessors();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Exchange result = null;
        Iterable<ProcessorExchangePair> pairs = this.createProcessorExchangePairs(exchange);
        if (this.isParallelProcessing) {
            List allPairs = CollectionConverter.toList(pairs);
            Exchange[] exchanges = new Exchange[allPairs.size()];
            final CountDownLatch completedExchanges = new CountDownLatch(allPairs.size());
            int i = 0;
            for (ProcessorExchangePair pair : pairs) {
                Processor producer = pair.getProcessor();
                exchanges[i] = pair.getExchange();
                this.updateNewExchange(exchanges[i], i, allPairs);
                ProcessCall call = new ProcessCall(exchanges[i], producer, new AsyncCallback(){

                    public void done(boolean doneSynchronously) {
                        completedExchanges.countDown();
                    }
                });
                this.executor.execute(call);
                ++i;
            }
            completedExchanges.await();
            if (this.aggregationStrategy != null) {
                for (Exchange resultExchange : exchanges) {
                    result = result == null ? resultExchange : this.aggregationStrategy.aggregate(result, resultExchange);
                }
            }
        } else {
            int i = 0;
            for (ProcessorExchangePair pair : pairs) {
                Processor producer = pair.getProcessor();
                Exchange subExchange = pair.getExchange();
                this.updateNewExchange(subExchange, i, pairs);
                producer.process(subExchange);
                if (this.aggregationStrategy != null) {
                    result = result == null ? subExchange : this.aggregationStrategy.aggregate(result, subExchange);
                }
                ++i;
            }
        }
        if (result != null) {
            ExchangeHelper.copyResults(exchange, result);
        }
    }

    protected void updateNewExchange(Exchange exchange, int i, Iterable<ProcessorExchangePair> allPairs) {
    }

    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(this.processors.size());
        Processor[] processorsArray = this.processors.toArray(new Processor[this.processors.size()]);
        for (int i = 0; i < processorsArray.length; ++i) {
            result.add(new ProcessorExchangePair(processorsArray[i], exchange.copy()));
        }
        return result;
    }

    @Override
    protected void doStop() throws Exception {
        this.shutdown.set(true);
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor.awaitTermination(0L, TimeUnit.SECONDS);
        }
        ServiceHelper.stopServices(this.processors);
    }

    @Override
    protected void doStart() throws Exception {
        this.shutdown.set(false);
        if (this.executor != null) {
            this.executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

                public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
                    ProcessCall call = (ProcessCall)runnable;
                    call.exchange.setException(new RejectedExecutionException());
                    call.callback.done(false);
                }
            });
        }
        ServiceHelper.startServices(this.processors);
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    class ProcessCall
    implements Runnable {
        private final Exchange exchange;
        private final AsyncCallback callback;
        private final Processor processor;

        public ProcessCall(Exchange exchange, Processor processor, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
            this.processor = processor;
        }

        public void run() {
            if (MulticastProcessor.this.shutdown.get()) {
                this.exchange.setException(new RejectedExecutionException());
                this.callback.done(false);
            } else {
                try {
                    this.processor.process(this.exchange);
                }
                catch (Exception ex) {
                    this.exchange.setException(ex);
                }
                this.callback.done(false);
            }
        }
    }

    static class ProcessorExchangePair {
        private final Processor processor;
        private final Exchange exchange;

        public ProcessorExchangePair(Processor processor, Exchange exchange) {
            this.processor = processor;
            this.exchange = exchange;
        }

        public Processor getProcessor() {
            return this.processor;
        }

        public Exchange getExchange() {
            return this.exchange;
        }
    }
}

