/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.converter.stream.StreamCache;
import org.apache.camel.model.InterceptorRef;
import org.apache.camel.model.InterceptorType;
import org.apache.camel.processor.Interceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamCachingInterceptor
extends Interceptor {
    public StreamCachingInterceptor() {
        this.setInterceptorLogic(new Processor(){

            public void process(Exchange exchange) throws Exception {
                StreamCache newBody = exchange.getIn().getBody(StreamCache.class);
                if (newBody != null) {
                    newBody.reset();
                    exchange.getIn().setBody(newBody);
                }
                StreamCachingInterceptor.this.proceed(exchange);
            }
        });
    }

    public StreamCachingInterceptor(Processor processor) {
        this();
        this.setProcessor(processor);
    }

    @Override
    public String toString() {
        return "StreamCachingInterceptor";
    }

    public static void noStreamCaching(List<InterceptorType> interceptors) {
        for (int i = 0; i < interceptors.size(); ++i) {
            InterceptorType interceptor = interceptors.get(i);
            if (!(interceptor instanceof InterceptorRef) || !(((InterceptorRef)interceptor).getInterceptor() instanceof StreamCachingInterceptor)) continue;
            interceptors.remove(interceptor);
        }
    }
}

