/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.interceptor;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.converter.stream.StreamCache;
import org.apache.camel.processor.interceptor.TraceInterceptor;
import org.apache.camel.spi.UnitOfWork;
import org.apache.camel.util.ObjectHelper;

public class TraceFormatter {
    private boolean showBreadCrumb = true;
    private boolean showNode = true;
    private boolean showExchangeId;
    private boolean showProperties = true;
    private boolean showHeaders = true;
    private boolean showBody = true;
    private boolean showBodyType = true;

    public Object format(TraceInterceptor interceptor, Exchange exchange) {
        Message in = exchange.getIn();
        Throwable exception = exchange.getException();
        return (this.showBreadCrumb ? this.getBreadCrumbID(exchange) + " " : "") + "-> " + this.getNodeMessage(interceptor) + " " + (this.showNode ? interceptor.getNode() + " " : "") + (Object)((Object)exchange.getPattern()) + (this.showExchangeId ? " Id: " + exchange.getExchangeId() : "") + (this.showProperties ? " Properties:" + exchange.getProperties() : "") + (this.showHeaders ? " Headers:" + in.getHeaders() : "") + (this.showBodyType ? " BodyType:" + this.getBodyTypeAsString(in) : "") + (this.showBody ? " Body:" + this.getBodyAsString(in) : "") + (exception != null ? " Exception: " + exception : "");
    }

    public boolean isShowBody() {
        return this.showBody;
    }

    public void setShowBody(boolean showBody) {
        this.showBody = showBody;
    }

    public boolean isShowBodyType() {
        return this.showBodyType;
    }

    public void setShowBodyType(boolean showBodyType) {
        this.showBodyType = showBodyType;
    }

    public boolean isShowBreadCrumb() {
        return this.showBreadCrumb;
    }

    public void setShowBreadCrumb(boolean showBreadCrumb) {
        this.showBreadCrumb = showBreadCrumb;
    }

    public boolean isShowExchangeId() {
        return this.showExchangeId;
    }

    public void setShowExchangeId(boolean showExchangeId) {
        this.showExchangeId = showExchangeId;
    }

    public boolean isShowHeaders() {
        return this.showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this.showHeaders = showHeaders;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties = showProperties;
    }

    public boolean isShowNode() {
        return this.showNode;
    }

    public void setShowNode(boolean showNode) {
        this.showNode = showNode;
    }

    protected Object getBreadCrumbID(Exchange exchange) {
        UnitOfWork unitOfWork = exchange.getUnitOfWork();
        return unitOfWork.getId();
    }

    protected Object getBodyAsString(Message in) {
        Object answer;
        StreamCache newBody = in.getBody(StreamCache.class);
        if (newBody != null) {
            in.setBody(newBody);
        }
        if ((answer = in.getBody(String.class)) == null) {
            answer = in.getBody();
        }
        if (newBody != null) {
            newBody.reset();
        }
        return answer;
    }

    protected Object getBodyTypeAsString(Message message) {
        String answer = ObjectHelper.classCanonicalName(message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }

    protected String getNodeMessage(TraceInterceptor interceptor) {
        return interceptor.getNode().idOrCreate();
    }
}

