/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.TypeConverter;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntrospectionSupport {
    private static final transient Log LOG = LogFactory.getLog(IntrospectionSupport.class);

    private IntrospectionSupport() {
    }

    public static boolean getProperties(Object target, Map props, String optionPrefix) {
        Method[] methods;
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        if (optionPrefix == null) {
            optionPrefix = "";
        }
        Class<?> clazz = target.getClass();
        for (Method method : methods = clazz.getMethods()) {
            String name = method.getName();
            Class<?> type = method.getReturnType();
            Class<?>[] params = method.getParameterTypes();
            if (!name.startsWith("get") || params.length != 0 || type == null || !IntrospectionSupport.isSettableType(type)) continue;
            try {
                String strValue;
                Object value = method.invoke(target, new Object[0]);
                if (value == null || (strValue = IntrospectionSupport.convertToString(value, type)) == null) continue;
                name = name.substring(3, 4).toLowerCase() + name.substring(4);
                props.put(optionPrefix + name, strValue);
                rc = true;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return rc;
    }

    public static Object getProperty(Object target, String prop) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (prop == null) {
            throw new IllegalArgumentException("prop was null.");
        }
        prop = prop.substring(0, 1).toUpperCase() + prop.substring(1);
        Class<?> clazz = target.getClass();
        Method method = IntrospectionSupport.getPropertyGetter(clazz, prop);
        return method.invoke(target, new Object[0]);
    }

    public static Method getPropertyGetter(Class type, String propertyName) throws NoSuchMethodException {
        Method method = type.getMethod("get" + ObjectHelper.capitalize(propertyName), new Class[0]);
        return method;
    }

    public static boolean setProperties(Object target, Map props, String optionPrefix) throws Exception {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            if (!IntrospectionSupport.setProperty(target, name = name.substring(optionPrefix.length()), value)) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static Map extractProperties(Map props, String optionPrefix) {
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        HashMap rc = new HashMap(props.size());
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            iter.remove();
        }
        return rc;
    }

    public static boolean setProperties(TypeConverter typeConverter, Object target, Map props) throws Exception {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!IntrospectionSupport.setProperty(typeConverter, target, (String)entry.getKey(), entry.getValue())) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map props) throws Exception {
        return IntrospectionSupport.setProperties(null, target, props);
    }

    public static boolean setProperty(TypeConverter typeConverter, Object target, String name, Object value) throws Exception {
        try {
            Class<?> clazz = target.getClass();
            Set<Method> setters = IntrospectionSupport.findSetterMethods(typeConverter, clazz, name, value);
            if (setters.isEmpty()) {
                return false;
            }
            IllegalArgumentException typeConvertionFailed = null;
            for (Method setter : setters) {
                if (value == null || setter.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                    setter.invoke(target, value);
                    return true;
                }
                try {
                    Object convertedValue = IntrospectionSupport.convert(typeConverter, setter.getParameterTypes()[0], value);
                    setter.invoke(target, convertedValue);
                    return true;
                }
                catch (IllegalArgumentException e) {
                    typeConvertionFailed = e;
                    LOG.trace((Object)("Setter " + setter + " with parameter type " + setter.getParameterTypes()[0] + " could not be used for type conertions of " + value));
                }
            }
            if (typeConvertionFailed != null) {
                throw new IllegalArgumentException("Could not find a suitable setter for property: " + name + " as there isn't a setter method with same type: " + value.getClass().getCanonicalName() + " nor type convertion possbile: " + typeConvertionFailed.getMessage());
            }
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                throw exception;
            }
            Error error = (Error)throwable;
            throw error;
        }
    }

    public static boolean setProperty(Object target, String name, Object value) throws Exception {
        return IntrospectionSupport.setProperty(null, target, name, value);
    }

    private static Object convert(TypeConverter typeConverter, Class type, Object value) throws URISyntaxException {
        if (typeConverter != null) {
            Object answer = typeConverter.convertTo(type, value);
            if (answer == null) {
                throw new IllegalArgumentException("Could not convert \"" + value + "\" to " + type.getName());
            }
            return answer;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setAsText(value.toString());
            return editor.getValue();
        }
        if (type == URI.class) {
            return new URI(value.toString());
        }
        return null;
    }

    private static String convertToString(Object value, Class type) throws URISyntaxException {
        PropertyEditor editor = PropertyEditorManager.findEditor(type);
        if (editor != null) {
            editor.setValue(value);
            return editor.getAsText();
        }
        if (type == URI.class) {
            return value.toString();
        }
        return null;
    }

    private static Set<Method> findSetterMethods(TypeConverter typeConverter, Class clazz, String name, Object value) {
        LinkedHashSet<Method> candidates = new LinkedHashSet<Method>();
        name = "set" + ObjectHelper.capitalize(name);
        while (clazz != Object.class) {
            Method[] methods;
            for (Method method : methods = clazz.getMethods()) {
                Class<?>[] params = method.getParameterTypes();
                if (!method.getName().equals(name) || params.length != 1) continue;
                Class<?> paramType = params[0];
                if (typeConverter == null && !IntrospectionSupport.isSettableType(paramType) && !paramType.isInstance(value)) continue;
                candidates.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        if (candidates.isEmpty()) {
            return candidates;
        }
        if (candidates.size() == 1) {
            return candidates;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Found " + candidates.size() + " suitable setter methods for setting " + name));
        }
        for (Method method : candidates) {
            if (!method.getParameterTypes()[0].isInstance(value)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Method " + method + " is the best candidate as it has parameter with same instance type"));
            }
            candidates.clear();
            candidates.add(method);
            return candidates;
        }
        return candidates;
    }

    private static boolean isSettableType(Class clazz) {
        if (PropertyEditorManager.findEditor(clazz) != null) {
            return true;
        }
        if (clazz == URI.class) {
            return true;
        }
        return clazz == Boolean.class;
    }

    public static String toString(Object target) {
        return IntrospectionSupport.toString(target, Object.class);
    }

    public static String toString(Object target, Class stopClass) {
        LinkedHashMap map = new LinkedHashMap();
        IntrospectionSupport.addFields(target, target.getClass(), stopClass, map);
        StringBuffer buffer = new StringBuffer(IntrospectionSupport.simpleName(target.getClass()));
        buffer.append(" {");
        Set entrySet = map.entrySet();
        boolean first = true;
        for (Map.Entry entry : entrySet) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(entry.getKey());
            buffer.append(" = ");
            IntrospectionSupport.appendToString(buffer, entry.getValue());
        }
        buffer.append("}");
        return buffer.toString();
    }

    protected static void appendToString(StringBuffer buffer, Object value) {
        buffer.append(value);
    }

    public static String simpleName(Class clazz) {
        String name = clazz.getName();
        int p = name.lastIndexOf(".");
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        return name;
    }

    private static void addFields(Object target, Class startClass, Class stopClass, LinkedHashMap map) {
        Field[] fields;
        if (startClass != stopClass) {
            IntrospectionSupport.addFields(target, startClass.getSuperclass(), stopClass, map);
        }
        for (Field field : fields = startClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                List<Object> o = field.get(target);
                if (o != null && o.getClass().isArray()) {
                    try {
                        o = Arrays.asList((Object[])o);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                map.put(field.getName(), o);
            }
            catch (Throwable e) {
                LOG.debug((Object)"Error adding fields", e);
            }
        }
    }
}

