/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.view;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.model.AggregatorType;
import org.apache.camel.model.ChoiceType;
import org.apache.camel.model.FilterType;
import org.apache.camel.model.FromType;
import org.apache.camel.model.OtherwiseType;
import org.apache.camel.model.ProcessorType;
import org.apache.camel.model.RecipientListType;
import org.apache.camel.model.ResequencerType;
import org.apache.camel.model.RoutingSlipType;
import org.apache.camel.model.SplitterType;
import org.apache.camel.model.ToType;
import org.apache.camel.model.WhenType;
import org.apache.camel.util.ObjectHelper;

public class NodeData {
    public String id;
    public String image;
    public String label;
    public String shape;
    public String edgeLabel;
    public String tooltop;
    public String nodeType;
    public boolean nodeWritten;
    public String url;
    public List<ProcessorType> outputs;
    public String association = "property";
    private final String imagePrefix;

    public NodeData(String id, Object node, String imagePrefix) {
        ProcessorType processorType;
        this.id = id;
        this.imagePrefix = imagePrefix;
        if (node instanceof ProcessorType) {
            processorType = (ProcessorType)node;
            this.edgeLabel = processorType.getLabel();
        }
        if (node instanceof FromType) {
            FromType fromType = (FromType)node;
            this.tooltop = fromType.getLabel();
            this.label = this.removeQueryString(this.tooltop);
            this.url = "http://activemq.apache.org/camel/message-endpoint.html";
        } else if (node instanceof ToType) {
            ToType toType = (ToType)node;
            this.tooltop = toType.getLabel();
            this.label = this.removeQueryString(this.tooltop);
            this.edgeLabel = "";
            this.url = "http://activemq.apache.org/camel/message-endpoint.html";
        } else if (node instanceof FilterType) {
            this.image = imagePrefix + "MessageFilterIcon.png";
            this.nodeType = "Message Filter";
        } else if (node instanceof WhenType) {
            this.image = imagePrefix + "MessageFilterIcon.png";
            this.nodeType = "When Filter";
            this.url = "http://activemq.apache.org/camel/content-based-router.html";
        } else if (node instanceof OtherwiseType) {
            this.nodeType = "Otherwise";
            this.edgeLabel = "";
            this.url = "http://activemq.apache.org/camel/content-based-router.html";
            this.tooltop = "Otherwise";
        } else if (node instanceof ChoiceType) {
            this.image = imagePrefix + "ContentBasedRouterIcon.png";
            this.nodeType = "Content Based Router";
            this.label = "";
            this.edgeLabel = "";
            ChoiceType choice = (ChoiceType)node;
            ArrayList<WhenType> outputs = new ArrayList<WhenType>(choice.getWhenClauses());
            if (choice.getOtherwise() != null) {
                outputs.add((WhenType)((Object)choice.getOtherwise()));
            }
            this.outputs = outputs;
        } else if (node instanceof RecipientListType) {
            this.image = imagePrefix + "RecipientListIcon.png";
            this.nodeType = "Recipient List";
        } else if (node instanceof RoutingSlipType) {
            this.image = imagePrefix + "RoutingTableIcon.png";
            this.nodeType = "Routing Slip";
            this.url = "http://activemq.apache.org/camel/routing-slip.html";
            this.tooltop = ((RoutingSlipType)node).getHeaderName();
        } else if (node instanceof SplitterType) {
            this.image = imagePrefix + "SplitterIcon.png";
            this.nodeType = "Splitter";
        } else if (node instanceof AggregatorType) {
            this.image = imagePrefix + "AggregatorIcon.png";
            this.nodeType = "Aggregator";
        } else if (node instanceof ResequencerType) {
            this.image = imagePrefix + "ResequencerIcon.png";
            this.nodeType = "Resequencer";
        }
        if (ObjectHelper.isNullOrBlank(this.nodeType) && node != null) {
            String name = node.getClass().getName();
            int idx = name.lastIndexOf(46);
            if (idx > 0) {
                name = name.substring(idx + 1);
            }
            if (name.endsWith("Type")) {
                name = name.substring(0, name.length() - 4);
            }
            this.nodeType = NodeData.insertSpacesBetweenCamelCase(name);
        }
        if (this.label == null) {
            if (ObjectHelper.isNullOrBlank(this.image)) {
                this.label = this.nodeType;
                this.shape = "box";
            } else {
                this.label = ObjectHelper.isNotNullAndNonEmpty(this.edgeLabel) ? "" : node.toString();
            }
        }
        if (ObjectHelper.isNullOrBlank(this.tooltop)) {
            if (ObjectHelper.isNotNullAndNonEmpty(this.nodeType)) {
                String description = ObjectHelper.isNotNullAndNonEmpty(this.edgeLabel) ? this.edgeLabel : this.label;
                this.tooltop = this.nodeType + ": " + description;
            } else {
                this.tooltop = this.label;
            }
        }
        if (ObjectHelper.isNullOrBlank(this.url) && ObjectHelper.isNotNullAndNonEmpty(this.nodeType)) {
            this.url = "http://activemq.apache.org/camel/" + this.nodeType.toLowerCase().replace(' ', '-') + ".html";
        }
        if (node instanceof ProcessorType && this.outputs == null) {
            processorType = (ProcessorType)node;
            this.outputs = processorType.getOutputs();
        }
    }

    protected String removeQueryString(String text) {
        int idx = text.indexOf("?");
        if (idx <= 0) {
            return text;
        }
        return text.substring(0, idx);
    }

    public static String insertSpacesBetweenCamelCase(String name) {
        boolean lastCharacterLowerCase = false;
        StringBuffer buffer = new StringBuffer();
        int size = name.length();
        for (int i = 0; i < size; ++i) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch)) {
                if (lastCharacterLowerCase) {
                    buffer.append(' ');
                }
                lastCharacterLowerCase = false;
            } else {
                lastCharacterLowerCase = true;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }
}

