/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.camel;

import javax.jbi.JBIException;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.impl.DefaultExchange;
import org.apache.servicemix.camel.JbiBinding;
import org.apache.servicemix.camel.JbiMessage;

public class JbiExchange
extends DefaultExchange {
    private final JbiBinding binding;
    private MessageExchange messageExchange;

    public JbiExchange(CamelContext context, JbiBinding binding) {
        super(context);
        this.binding = binding;
        this.populateProperties();
    }

    public JbiExchange(CamelContext context, JbiBinding binding, MessageExchange messageExchange) {
        super(context);
        this.binding = binding;
        this.messageExchange = messageExchange;
        this.setPattern(ExchangePattern.fromWsdlUri((String)messageExchange.getPattern().toString()));
        this.populateProperties();
    }

    public JbiMessage getIn() {
        return (JbiMessage)super.getIn();
    }

    public JbiMessage getOut() {
        return (JbiMessage)super.getOut();
    }

    public JbiMessage getOut(boolean lazyCreate) {
        return (JbiMessage)super.getOut(lazyCreate);
    }

    public JbiMessage getFault() {
        return (JbiMessage)super.getFault();
    }

    public JbiMessage getFault(boolean lazyCreate) {
        return (JbiMessage)super.getFault(lazyCreate);
    }

    public Exchange newInstance() {
        return new JbiExchange(this.getContext(), this.getBinding(), this.getMessageExchange());
    }

    public JbiBinding getBinding() {
        return this.binding;
    }

    public MessageExchange getMessageExchange() {
        return this.messageExchange;
    }

    public NormalizedMessage getInMessage() {
        return this.getIn().getNormalizedMessage();
    }

    public NormalizedMessage getOutMessage() {
        return this.getOut().getNormalizedMessage();
    }

    public NormalizedMessage getFaultMessage() {
        return this.getFault().getNormalizedMessage();
    }

    protected JbiMessage createInMessage() {
        return this.createMessage("in");
    }

    protected JbiMessage createOutMessage() {
        if (this.messageExchange instanceof InOnly) {
            return new JbiMessage();
        }
        return this.createMessage("out");
    }

    protected JbiMessage createFaultMessage() {
        return this.createMessage("fault");
    }

    private JbiMessage createMessage(String name) {
        if (this.messageExchange != null) {
            try {
                NormalizedMessage msg = this.messageExchange.getMessage(name);
                if (msg == null) {
                    msg = this.messageExchange.createMessage();
                    this.messageExchange.setMessage(msg, name);
                }
                return new JbiMessage(msg);
            }
            catch (JBIException e) {
                throw new RuntimeException(e);
            }
        }
        return new JbiMessage();
    }

    private void populateProperties() {
        if (this.messageExchange != null && this.messageExchange.getOperation() != null) {
            this.setProperty("jbi.operation", this.messageExchange.getOperation().toString());
        }
    }
}

