/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell;

import java.util.ArrayList;
import java.util.List;
import org.apache.geronimo.gshell.ErrorNotification;
import org.apache.geronimo.gshell.command.CommandExecutor;
import org.apache.geronimo.gshell.common.Arguments;
import org.apache.geronimo.gshell.expression.JexlExpressionEvaluator;
import org.apache.geronimo.gshell.parser.ASTCommandLine;
import org.apache.geronimo.gshell.parser.ASTExpression;
import org.apache.geronimo.gshell.parser.ASTOpaqueString;
import org.apache.geronimo.gshell.parser.ASTPlainString;
import org.apache.geronimo.gshell.parser.ASTProcess;
import org.apache.geronimo.gshell.parser.ASTQuotedString;
import org.apache.geronimo.gshell.parser.CommandLineParserVisitor;
import org.apache.geronimo.gshell.parser.SimpleNode;
import org.apache.geronimo.gshell.shell.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutingVisitor
implements CommandLineParserVisitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Environment env;
    private CommandExecutor executor;

    public ExecutingVisitor(CommandExecutor executor, Environment env) {
        assert (executor != null);
        assert (env != null);
        this.executor = executor;
        this.env = env;
    }

    public Object visit(SimpleNode node, Object data) {
        assert (node != null);
        throw new Error("Unhandled node type: " + node.getClass().getName());
    }

    public Object visit(ASTCommandLine node, Object data) {
        assert (node != null);
        return node.childrenAccept(this, data);
    }

    public Object visit(ASTExpression node, Object data) {
        assert (node != null);
        Object[][] commands = new Object[node.jjtGetNumChildren()][];
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            ASTProcess proc = (ASTProcess)node.jjtGetChild(i);
            ArrayList list = new ArrayList(proc.jjtGetNumChildren());
            proc.childrenAccept(this, list);
            commands[i] = list.toArray(new Object[list.size()]);
            assert (list.size() >= 1);
        }
        try {
            return this.executor.execute(commands);
        }
        catch (Exception e) {
            String s = Arguments.asString(commands[0]);
            for (int i = 1; i < commands.length; ++i) {
                s = s + " | " + Arguments.asString(commands[i]);
            }
            throw new ErrorNotification("Shell execution failed; commands=" + s, e);
        }
    }

    public Object visit(ASTProcess node, Object data) {
        return null;
    }

    private Object appendString(String value, Object data) {
        assert (data != null);
        assert (data instanceof List);
        List args = (List)data;
        args.add(value);
        return value;
    }

    private String evaluate(String expr) {
        assert (expr != null);
        JexlExpressionEvaluator evaluator = new JexlExpressionEvaluator(this.env.getVariables());
        try {
            return evaluator.parse(expr);
        }
        catch (Exception e) {
            throw new ErrorNotification("Failed to evaluate expression: " + expr, e);
        }
    }

    public Object visit(ASTQuotedString node, Object data) {
        String value = this.evaluate(node.getValue());
        return this.appendString(value, data);
    }

    public Object visit(ASTOpaqueString node, Object data) {
        return this.appendString(node.getValue(), data);
    }

    public Object visit(ASTPlainString node, Object data) {
        String value = this.evaluate(node.getValue());
        return this.appendString(value, data);
    }
}

