/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.commands.builtins;

import org.apache.geronimo.gshell.ExitNotification;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.Variables;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.layout.LayoutManager;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;

@CommandComponent(id="gshell-builtins:exit", description="Exit the (sub)shell")
public class ExitCommand
extends OsgiCommandSupport {
    @Argument(description="System exit code")
    private int exitCode = 0;

    protected Object doExecute() throws Exception {
        if (this.context.getVariables().get(LayoutManager.CURRENT_NODE) != null) {
            this.log.info("Exiting subshell");
            for (Variables v = this.context.getVariables(); v != null && v.get(LayoutManager.CURRENT_NODE) != null; v = v.parent()) {
                v.unset(LayoutManager.CURRENT_NODE);
            }
            return SUCCESS;
        }
        this.log.info("Exiting w/code: {}", (Object)this.exitCode);
        throw new ExitNotification(this.exitCode);
    }
}

