/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.console;

import java.io.IOException;
import java.io.PrintWriter;
import jline.ConsoleReader;
import jline.Terminal;
import org.apache.geronimo.gshell.command.IO;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;

@Component(role=PromptReader.class, instantiationStrategy="per-lookup")
public class PromptReader
implements Initializable {
    @Requirement
    private Terminal terminal;
    @Requirement
    private IO io;
    private char mask = (char)42;
    private ConsoleReader reader;

    public PromptReader() {
    }

    public PromptReader(Terminal terminal, IO io) {
        this.terminal = terminal;
        this.io = io;
    }

    public char getMask() {
        return this.mask;
    }

    public void setMask(char mask) {
        this.mask = mask;
    }

    public void initialize() throws InitializationException {
        try {
            this.reader = new ConsoleReader(this.io.inputStream, new PrintWriter(this.io.outputStream, true), null, this.terminal);
        }
        catch (IOException e) {
            throw new InitializationException("Failed to create reader", e);
        }
    }

    public String readLine(String prompt) throws IOException {
        assert (prompt != null);
        return this.reader.readLine(prompt);
    }

    public String readLine(String prompt, char mask) throws IOException {
        assert (prompt != null);
        return this.reader.readLine(prompt, Character.valueOf(mask));
    }

    public String readPassword(String prompt) throws IOException {
        assert (prompt != null);
        return this.reader.readLine(prompt, Character.valueOf(this.mask));
    }
}

