/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.security.auth.login.LoginContext;
import org.apache.geronimo.gshell.remote.client.RemoteExecuteException;
import org.apache.geronimo.gshell.remote.client.auth.RemoteLoginModule;
import org.apache.geronimo.gshell.remote.client.handler.ClientMessageHandler;
import org.apache.geronimo.gshell.remote.client.handler.ClientSessionContext;
import org.apache.geronimo.gshell.remote.crypto.CryptoContext;
import org.apache.geronimo.gshell.remote.jaas.JaasConfigurationHelper;
import org.apache.geronimo.gshell.remote.jaas.UsernamePasswordCallbackHandler;
import org.apache.geronimo.gshell.remote.message.CloseShellMessage;
import org.apache.geronimo.gshell.remote.message.ConnectMessage;
import org.apache.geronimo.gshell.remote.message.EchoMessage;
import org.apache.geronimo.gshell.remote.message.ExecuteMessage;
import org.apache.geronimo.gshell.remote.message.OpenShellMessage;
import org.apache.geronimo.gshell.whisper.message.Message;
import org.apache.geronimo.gshell.whisper.message.MessageHandler;
import org.apache.geronimo.gshell.whisper.transport.Session;
import org.apache.geronimo.gshell.whisper.transport.Transport;
import org.apache.geronimo.gshell.whisper.transport.TransportFactoryLocator;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoSession;
import org.apache.mina.handler.demux.DemuxingIoHandler;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=RshClient.class, instantiationStrategy="per-lookup")
public class RshClient
implements Initializable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Requirement
    private CryptoContext crypto;
    @Requirement
    private TransportFactoryLocator locator;
    private Transport transport;
    private Session session;
    @Requirement(role=ClientMessageHandler.class)
    private List<ClientMessageHandler> handlers;

    public RshClient() {
    }

    public RshClient(CryptoContext crypto, TransportFactoryLocator locator, List<ClientMessageHandler> handlers) {
        this.crypto = crypto;
        this.locator = locator;
        this.handlers = handlers;
    }

    @Override
    public void initialize() throws InitializationException {
        new JaasConfigurationHelper("client.login.conf").initialize();
    }

    public void connect(URI remote, URI local) throws Exception {
        Object factory = this.locator.locate(remote);
        this.transport = factory.connect(remote, local, (IoHandler)new Handler());
        this.session = this.transport.getSession();
        this.log.debug("Connected to: {}", (Object)remote);
    }

    public InputStream getInputStream() {
        return this.session.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.session.getOutputStream();
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void close() {
        this.transport.close();
    }

    public void login(String username, String password) throws Exception {
        this.doHandshake();
        this.doLogin(username, password);
    }

    private void doHandshake() throws Exception {
        this.log.debug("Handshaking");
        ClientSessionContext context = ClientSessionContext.BINDER.lookup(this.session.getSession());
        Message response = this.session.request(new ConnectMessage(this.crypto.getPublicKey()));
        if (!(response instanceof ConnectMessage.Result)) {
            throw new InternalError("Unexpected handshake response: " + response);
        }
        ConnectMessage.Result result = (ConnectMessage.Result)response;
        context.pk = result.getPublicKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLogin(String username, String password) throws Exception {
        this.log.debug("Logging in: {}", (Object)username);
        ClientSessionContext context = ClientSessionContext.BINDER.lookup(this.session.getSession());
        UsernamePasswordCallbackHandler callbackHandler = new UsernamePasswordCallbackHandler(username, password);
        LoginContext loginContext = new LoginContext("RshClient", callbackHandler);
        RemoteLoginModule.setTransport(this.transport);
        try {
            loginContext.login();
        }
        finally {
            RemoteLoginModule.unsetTransport();
        }
        context.subject = loginContext.getSubject();
        this.log.debug("Subject: {}", (Object)context.subject);
    }

    public void echo(String text) throws Exception {
        assert (text != null);
        this.log.debug("Echoing: {}", (Object)text);
        this.session.send(new EchoMessage(text)).join();
    }

    public void openShell() throws Exception {
        this.log.debug("Opening remote shell");
        Message resp = this.session.request(new OpenShellMessage());
    }

    public void closeShell() throws Exception {
        this.log.debug("Closing remote shell");
        Message resp = this.session.request(new CloseShellMessage());
    }

    private Object doExecute(ExecuteMessage msg) throws Exception {
        assert (msg != null);
        ExecuteMessage.Result result = (ExecuteMessage.Result)this.session.request(msg);
        if (result instanceof ExecuteMessage.Notification) {
            ExecuteMessage.Notification n = (ExecuteMessage.Notification)result;
            throw n.getNotification();
        }
        if (result instanceof ExecuteMessage.Fault) {
            ExecuteMessage.Fault fault = (ExecuteMessage.Fault)result;
            throw new RemoteExecuteException(fault.getCause());
        }
        Object rv = result.getResult();
        this.log.debug("Command result: {}", rv);
        return rv;
    }

    public Object execute(String line) throws Exception {
        assert (line != null);
        return this.doExecute(new ExecuteMessage(line));
    }

    public Object execute(Object ... args) throws Exception {
        assert (args != null);
        return this.doExecute(new ExecuteMessage(args));
    }

    public Object execute(String path, Object[] args) throws Exception {
        assert (path != null);
        assert (args != null);
        return this.doExecute(new ExecuteMessage(path, args));
    }

    public Object execute(Object[][] cmds) throws Exception {
        assert (cmds != null);
        return this.doExecute(new ExecuteMessage(cmds));
    }

    private class Handler
    extends DemuxingIoHandler {
        public Handler() throws Exception {
            if (RshClient.this.handlers.isEmpty()) {
                throw new Error("No message handlers were discovered");
            }
            for (ClientMessageHandler handler : RshClient.this.handlers) {
                this.register(handler);
            }
        }

        public void register(MessageHandler handler) {
            assert (handler != null);
            Class type = handler.getType();
            RshClient.this.log.debug("Registering handler: {} -> {}", (Object)type.getSimpleName(), (Object)handler);
            this.addMessageHandler(type, handler);
        }

        public void sessionOpened(IoSession session) throws Exception {
            assert (session != null);
            ClientSessionContext context = ClientSessionContext.BINDER.bind(session, new ClientSessionContext());
            RshClient.this.log.debug("Created session context: {}", (Object)context);
        }

        public void sessionClosed(IoSession session) throws Exception {
            assert (session != null);
            ClientSessionContext context = ClientSessionContext.BINDER.unbind(session);
            RshClient.this.log.debug("Removed session context: {}", (Object)context);
        }
    }
}

