/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import jline.Terminal;
import org.apache.geronimo.gshell.ExitNotification;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.console.PromptReader;
import org.apache.geronimo.gshell.remote.client.RshClient;
import org.apache.geronimo.gshell.remote.client.handler.ClientMessageHandler;
import org.apache.geronimo.gshell.remote.client.proxy.RemoteShellProxy;
import org.apache.geronimo.gshell.remote.crypto.CryptoContext;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;
import org.apache.geronimo.gshell.whisper.transport.TransportFactoryLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandComponent(id="gshell-remote:rsh", description="Connect to a remote GShell server")
public class SpringRshCommand
extends OsgiCommandSupport {
    @Option(name="-b", aliases={"--bind"}, metaVar="URI", description="Bind local address to URI")
    private URI local;
    @Option(name="-u", aliases={"--username"}, metaVar="USERNAME", description="Remote user name")
    private String username;
    @Option(name="-p", aliases={"--password"}, metaVar="PASSWORD", description="Remote user password")
    private String password;
    @Argument(metaVar="URI", required=true, index=0, description="Connect to remote server at URI")
    private URI remote;
    @Argument(metaVar="COMMAND", index=1, multiValued=true, description="Execute COMMAND in remote shell")
    private List<String> command = new ArrayList<String>();
    private Terminal terminal;
    private CryptoContext crypto;
    private TransportFactoryLocator locator;
    private List<ClientMessageHandler> handlers;

    public SpringRshCommand(Terminal terminal, CryptoContext crypto, TransportFactoryLocator locator, List<ClientMessageHandler> handlers) {
        this.terminal = terminal;
        this.crypto = crypto;
        this.locator = locator;
        this.handlers = handlers;
    }

    @Override
    protected OsgiCommandSupport createCommand() throws Exception {
        return new SpringRshCommand(this.terminal, this.crypto, this.locator, this.handlers);
    }

    @Override
    protected Object doExecute() throws Exception {
        this.io.info("Connecting to: {}", this.remote);
        RshClient client = new RshClient(this.crypto, this.locator, this.handlers);
        client.initialize();
        PromptReader prompter = new PromptReader(this.terminal, this.io);
        prompter.initialize();
        client.connect(this.remote, this.local);
        this.io.info("Connected");
        if (this.username == null || this.password == null) {
            if (this.username == null) {
                this.username = prompter.readLine("Username: ");
            }
            if (this.password == null) {
                this.password = prompter.readPassword("Password: ");
            }
        }
        client.login(this.username, this.password);
        RemoteShellProxy shell = new RemoteShellProxy(client, this.io, this.terminal);
        Object rv = SUCCESS;
        try {
            shell.run(this.command.toArray());
        }
        catch (ExitNotification n) {
            rv = n.code;
        }
        shell.close();
        this.io.verbose("Disconnecting");
        client.close();
        this.io.verbose("Disconnected");
        return rv;
    }
}

