/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.client.auth;

import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.geronimo.gshell.remote.client.auth.ClientPrincipal;
import org.apache.geronimo.gshell.remote.message.LoginMessage;
import org.apache.geronimo.gshell.whisper.message.Message;
import org.apache.geronimo.gshell.whisper.transport.Session;
import org.apache.geronimo.gshell.whisper.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteLoginModule
implements LoginModule {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Subject subject;
    private CallbackHandler callbackHandler;
    private String username;
    private Object clientIdentity;
    private Principal principal;
    private static final ThreadLocal<Transport> transportHolder = new ThreadLocal();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    private void reset() {
        this.username = null;
        this.clientIdentity = null;
        this.principal = null;
    }

    @Override
    public boolean login() throws LoginException {
        Message response;
        Transport transport = RemoteLoginModule.getTransport();
        Session session = transport.getSession();
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new LoginException(e.getMessage());
        }
        this.username = ((NameCallback)callbacks[0]).getName();
        char[] password = ((PasswordCallback)callbacks[1]).getPassword();
        try {
            response = session.request(new LoginMessage(this.username, password));
        }
        catch (Exception e) {
            throw new LoginException(e.getMessage());
        }
        if (response instanceof LoginMessage.Success) {
            this.clientIdentity = ((LoginMessage.Success)response).getToken();
            this.log.debug("Client identity: {}", this.clientIdentity);
        } else if (response instanceof LoginMessage.Failure) {
            LoginMessage.Failure failure = (LoginMessage.Failure)response;
            throw new LoginException("Login failed: " + failure.getReason());
        }
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.principal = new ClientPrincipal(this.username, this.clientIdentity);
        this.log.debug("Principal: {}", (Object)this.principal);
        this.subject.getPrincipals().add(this.principal);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.reset();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.principal);
        return true;
    }

    public static void setTransport(Transport transport) {
        assert (transport != null);
        transportHolder.set(transport);
    }

    public static void unsetTransport() {
        transportHolder.remove();
    }

    private static Transport getTransport() {
        Transport transport = transportHolder.get();
        if (transport == null) {
            throw new IllegalStateException("Transport has not been bound to the executing thread");
        }
        return transport;
    }
}

