/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.remote.server.handler;

import org.apache.geronimo.gshell.common.Notification;
import org.apache.geronimo.gshell.remote.message.ExecuteMessage;
import org.apache.geronimo.gshell.remote.server.handler.ServerMessageHandlerSupport;
import org.apache.geronimo.gshell.remote.server.handler.ServerSessionContext;
import org.apache.geronimo.gshell.spring.EnvironmentTargetSource;
import org.apache.geronimo.gshell.spring.ProxyIO;
import org.apache.geronimo.gshell.whisper.transport.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringExecuteHandler
extends ServerMessageHandlerSupport<ExecuteMessage> {
    public SpringExecuteHandler() {
        super(ExecuteMessage.class);
    }

    @Override
    public void handle(Session session, ServerSessionContext context, ExecuteMessage message) throws Exception {
        ExecuteMessage.Result reply;
        ProxyIO.setIO(context.io);
        EnvironmentTargetSource.setEnvironment(context.env);
        try {
            Object result = message.execute(context.shell);
            this.log.debug("Result: {}", result);
            reply = new ExecuteMessage.Result(result);
        }
        catch (Notification n) {
            this.log.debug("Notification: " + n);
            reply = new ExecuteMessage.Notification(n);
        }
        catch (Throwable t) {
            this.log.debug("Fault: " + t);
            reply = new ExecuteMessage.Fault(t);
        }
        reply.setCorrelationId(message.getId());
        session.send(reply);
    }
}

