/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.spring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.geronimo.gshell.command.IO;

public class ProxyIO
extends IO {
    private static final ThreadLocal<IO> TLS_IO = new InheritableThreadLocal<IO>();

    public ProxyIO() {
        super((InputStream)new ProxyInputStream(){

            protected InputStream getIn() {
                return ((IO)TLS_IO.get()).inputStream;
            }
        }, (OutputStream)new ProxyOutputStream(){

            protected OutputStream getOut() {
                return ((IO)TLS_IO.get()).outputStream;
            }
        }, new ProxyOutputStream(){

            protected OutputStream getOut() {
                return ((IO)TLS_IO.get()).errorStream;
            }
        });
    }

    public static void setIO(IO io) {
        TLS_IO.set(io);
    }

    public static IO getIO() {
        return TLS_IO.get();
    }

    protected static abstract class ProxyOutputStream
    extends OutputStream {
        protected ProxyOutputStream() {
        }

        public void write(int b) throws IOException {
            this.getOut().write(b);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if ((off | len | b.length - (len + off) | off + len) < 0) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = 0; i < len; ++i) {
                this.write(b[off + i]);
            }
        }

        public void flush() throws IOException {
            this.getOut().flush();
        }

        public void close() throws IOException {
            try {
                this.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getOut().close();
        }

        protected abstract OutputStream getOut();
    }

    protected static abstract class ProxyInputStream
    extends InputStream {
        protected ProxyInputStream() {
        }

        public int read() throws IOException {
            return this.getIn().read();
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.getIn().read(b, off, len);
        }

        public long skip(long n) throws IOException {
            return this.getIn().skip(n);
        }

        public int available() throws IOException {
            return this.getIn().available();
        }

        public void close() throws IOException {
            this.getIn().close();
        }

        public synchronized void mark(int readlimit) {
            this.getIn().mark(readlimit);
        }

        public synchronized void reset() throws IOException {
            this.getIn().reset();
        }

        public boolean markSupported() {
            return this.getIn().markSupported();
        }

        protected abstract InputStream getIn();
    }
}

