/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.request;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.geronimo.gshell.common.Duration;
import org.apache.geronimo.gshell.common.tostring.ToStringBuilder;
import org.apache.geronimo.gshell.common.tostring.ToStringStyle;
import org.apache.geronimo.gshell.whisper.message.Message;
import org.apache.geronimo.gshell.whisper.request.RequestTimeoutException;
import org.apache.geronimo.gshell.whisper.request.ResponseHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandle {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final Lock lock = new ReentrantLock();
    private final BlockingQueue<Object> responses = new LinkedBlockingQueue<Object>();
    private final Message message;
    private final Duration timeout;
    private volatile boolean endOfResponses;
    private volatile boolean signaled;

    public RequestHandle(Message message, Duration timeout) {
        assert (message != null);
        assert (timeout != null);
        this.message = message;
        this.timeout = timeout;
    }

    public RequestHandle(Message message, long timeout, TimeUnit timeoutUnit) {
        this(message, new Duration(timeout, timeoutUnit));
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestHandle)) {
            return false;
        }
        RequestHandle request = (RequestHandle)obj;
        return this.getId().equals(request.getId());
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.getId()).append("signaled", this.signaled).append("message", this.message).toString();
    }

    public Message getMessage() {
        return this.message;
    }

    public Message.ID getId() {
        return this.getMessage().getId();
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public boolean hasResponse() {
        return !this.responses.isEmpty();
    }

    public ResponseHandle awaitResponse() throws RequestTimeoutException, InterruptedException {
        this.chechEndOfResponses();
        this.log.debug("Waiting for response");
        ResponseHandle resp = this.decodeResponse(this.responses.take());
        this.log.trace("Received response: {}", (Object)resp);
        return resp;
    }

    public ResponseHandle awaitResponse(long timeout, TimeUnit unit) throws RequestTimeoutException, InterruptedException {
        this.chechEndOfResponses();
        this.log.debug("Polling for response");
        ResponseHandle resp = this.decodeResponse(this.responses.poll(timeout, unit));
        if (this.log.isTraceEnabled()) {
            if (resp != null) {
                this.log.trace("Received response: {}", (Object)resp);
            } else {
                this.log.trace("Operation timed out before the response was signaled");
            }
        }
        return resp;
    }

    public ResponseHandle awaitResponseUninterruptibly() throws RequestTimeoutException {
        while (true) {
            try {
                return this.awaitResponse();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private ResponseHandle decodeResponse(Object obj) {
        if (obj instanceof ResponseHandle) {
            return (ResponseHandle)obj;
        }
        if (obj == null) {
            return null;
        }
        if (obj == RequestTimeoutException.class) {
            throw new RequestTimeoutException(this.getId());
        }
        throw new InternalError();
    }

    private void chechEndOfResponses() {
        if (this.endOfResponses && this.responses.isEmpty()) {
            throw new IllegalStateException("All responses has been retrieved already");
        }
    }

    private void queueResponse(Object answer) {
        this.signaled = true;
        this.responses.add(answer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signal(ResponseHandle response) {
        assert (response != null);
        this.lock.lock();
        try {
            if (this.log.isTraceEnabled()) {
                this.log.debug("Signal response: {}", (Object)response);
            } else {
                this.log.debug("Signal response: {}", (Object)response.getRequest().getId());
            }
            this.queueResponse(response);
            if (response.getType() != ResponseHandle.Type.PARTIAL) {
                this.endOfResponses = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeout() {
        this.lock.lock();
        try {
            this.log.debug("Timeout");
            this.queueResponse(RequestTimeoutException.class);
            this.endOfResponses = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSignaled() {
        this.lock.lock();
        try {
            boolean bl = this.signaled;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }
}

