/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.request;

import org.apache.geronimo.gshell.whisper.message.Message;
import org.apache.geronimo.gshell.whisper.request.RequestHandle;
import org.apache.geronimo.gshell.whisper.request.RequestManager;
import org.apache.geronimo.gshell.whisper.request.ResponseHandle;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterAdapter;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestResponseFilter
extends IoFilterAdapter {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void sessionCreated(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        RequestManager.BINDER.bind(session, new RequestManager());
        nextFilter.sessionCreated(session);
    }

    public void sessionClosed(IoFilter.NextFilter nextFilter, IoSession session) throws Exception {
        RequestManager manager = RequestManager.BINDER.unbind(session);
        manager.close();
        nextFilter.sessionClosed(session);
    }

    public void filterWrite(IoFilter.NextFilter nextFilter, IoSession session, IoFilter.WriteRequest writeRequest) throws Exception {
        Object message = writeRequest.getMessage();
        if (message instanceof RequestHandle) {
            RequestHandle request = (RequestHandle)message;
            RequestManager manager = RequestManager.BINDER.lookup(session);
            manager.register(request);
            writeRequest = new IoFilter.WriteRequest((Object)request.getMessage(), writeRequest.getFuture(), writeRequest.getDestination());
        }
        nextFilter.filterWrite(session, writeRequest);
    }

    public void messageReceived(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        Message msg = null;
        Message.ID id = null;
        if (message instanceof Message) {
            msg = (Message)message;
            id = msg.getCorrelationId();
        }
        RequestManager manager = RequestManager.BINDER.lookup(session);
        if (id != null && manager.contains(id)) {
            RequestHandle request = manager.deregister(id);
            ResponseHandle response = new ResponseHandle(request, msg, ResponseHandle.Type.WHOLE);
            request.signal(response);
        } else {
            nextFilter.messageReceived(session, message);
        }
    }

    public void messageSent(IoFilter.NextFilter nextFilter, IoSession session, Object message) throws Exception {
        if (message instanceof RequestHandle) {
            RequestHandle request = (RequestHandle)message;
            RequestManager manager = RequestManager.BINDER.lookup(session);
            manager.activate(request.getId());
        }
        nextFilter.messageSent(session, message);
    }
}

