/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.rfile;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.geronimo.gshell.whisper.rfile.RemoteFileURLConnection;
import org.codehaus.plexus.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=URLStreamHandler.class, hint="rfile", instantiationStrategy="singleton")
public class RemoteFileURLStreamHandler
extends URLStreamHandler {
    public static final String PROTOCOL = "rfile";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected URLConnection openConnection(URL url) throws IOException {
        assert (url != null);
        String protocol = url.getProtocol();
        if (!PROTOCOL.equals(protocol)) {
            throw new IllegalArgumentException("Invalid protocol: " + protocol);
        }
        this.log.debug("Opening connection: {}", (Object)url);
        return new RemoteFileURLConnection(url);
    }
}

