/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;
import org.apache.geronimo.gshell.whisper.ssl.SSLContextFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=SSLContextFactory.class, hint="bogus")
public class BogusSSLContextFactory
implements SSLContextFactory,
Initializable {
    private static final String PROTOCOL = "TLS";
    private static final String DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM = "SunX509";
    private static final String KEY_MANAGER_FACTORY_ALGORITHM;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean preload = true;
    private String keystoreResource = "bogus.cert";
    private char[] keystorePassword = new char[]{'b', 'o', 'g', 'u', 's', 'p', 'w'};
    private SSLContext serverInstance;
    private SSLContext clientInstance;

    public synchronized void initialize() throws InitializationException {
        if (this.preload) {
            this.log.debug("Preloading SSLContext instances");
            try {
                this.createServerContext();
                this.createClientContext();
            }
            catch (GeneralSecurityException e) {
                throw new InitializationException("Failed to setup SSLContext instances", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SSLContext createServerContext() throws GeneralSecurityException {
        if (this.serverInstance == null) {
            KeyStore keyStore;
            try {
                keyStore = KeyStore.getInstance("JKS");
                InputStream in = this.getClass().getResourceAsStream(this.keystoreResource);
                if (in == null) {
                    throw new GeneralSecurityException("Failed to load bogus keystore from resource: " + this.keystoreResource);
                }
                try {
                    keyStore.load(in, this.keystorePassword);
                }
                finally {
                    IOUtil.close(in);
                }
            }
            catch (IOException e) {
                throw new GeneralSecurityException("Failed to load bogus keystore", e);
            }
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KEY_MANAGER_FACTORY_ALGORITHM);
            keyManagerFactory.init(keyStore, this.keystorePassword);
            SSLContext context = SSLContext.getInstance(PROTOCOL);
            context.init(keyManagerFactory.getKeyManagers(), BogusTrustManagerFactory.X509_MANAGERS, null);
            this.serverInstance = context;
            this.log.debug("Created server SSLContext: {}", (Object)this.serverInstance);
        }
        return this.serverInstance;
    }

    public synchronized SSLContext createClientContext() throws GeneralSecurityException {
        if (this.clientInstance == null) {
            SSLContext context = SSLContext.getInstance(PROTOCOL);
            context.init(null, BogusTrustManagerFactory.X509_MANAGERS, null);
            this.clientInstance = context;
            this.log.debug("Created client SSLContext: {}", (Object)this.clientInstance);
        }
        return this.clientInstance;
    }

    static {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = DEFAULT_KEY_MANAGER_FACTORY_ALGORITHM;
        }
        KEY_MANAGER_FACTORY_ALGORITHM = algorithm;
    }

    private static class BogusTrustManagerFactory
    extends TrustManagerFactorySpi {
        private static final X509TrustManager X509 = new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] c, String s) throws CertificateException {
            }

            public void checkServerTrusted(X509Certificate[] c, String s) throws CertificateException {
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        private static final TrustManager[] X509_MANAGERS = new TrustManager[]{X509};

        private BogusTrustManagerFactory() {
        }

        protected TrustManager[] engineGetTrustManagers() {
            return X509_MANAGERS;
        }

        protected void engineInit(KeyStore keystore) throws KeyStoreException {
        }

        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        }
    }
}

