/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.whisper.transport.base;

import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.geronimo.gshell.whisper.transport.Session;
import org.apache.geronimo.gshell.whisper.transport.Transport;
import org.apache.geronimo.gshell.whisper.transport.base.AddressFactory;
import org.apache.geronimo.gshell.whisper.transport.base.BaseConfiguration;
import org.apache.geronimo.gshell.whisper.transport.base.BaseService;
import org.apache.geronimo.gshell.whisper.transport.base.SessionAdapter;
import org.apache.geronimo.gshell.whisper.transport.base.ThreadPoolModel;
import org.apache.geronimo.gshell.whisper.util.SessionAttributeBinder;
import org.apache.mina.common.CloseFuture;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.IoConnector;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.ThreadModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTransport<T extends IoConnector>
extends BaseService
implements Transport {
    private static final AtomicLong INSTANCE_COUNTER = new AtomicLong(0L);
    private static final SessionAttributeBinder<Transport> TRANSPORT = new SessionAttributeBinder(Transport.class);
    protected URI remoteLocation;
    protected SocketAddress remoteAddress;
    protected URI localLocation;
    protected SocketAddress localAddress;
    protected T connector;
    protected Session session;
    private Transport.Configuration config;

    protected BaseTransport(AddressFactory addressFactory) {
        super(addressFactory);
    }

    protected abstract Transport.Configuration createConfiguration();

    @Override
    public synchronized Transport.Configuration getConfiguration() {
        if (this.config == null) {
            this.config = this.createConfiguration();
        }
        return this.config;
    }

    @Override
    public synchronized void setConfiguration(Transport.Configuration config) {
        assert (config != null);
        this.config = config;
        this.log.debug("Using configuration: {}", (Object)config);
    }

    @Override
    protected synchronized BaseConfiguration getBaseConfiguration() {
        return (BaseConfiguration)((Object)this.getConfiguration());
    }

    @Override
    protected synchronized ThreadModel createThreadModel() throws Exception {
        return new ThreadPoolModel(this.getClass(), INSTANCE_COUNTER);
    }

    protected abstract T createConnector() throws Exception;

    synchronized void connect(URI remote, URI local) throws Exception {
        this.remoteLocation = remote;
        this.remoteAddress = this.addressFactory.create(remote);
        this.localLocation = local;
        this.localAddress = this.addressFactory.create(local);
        this.connect();
    }

    synchronized void connect() throws Exception {
        this.log.debug("Connecting");
        this.connector = this.createConnector();
        this.log.debug("Connector: {}", this.connector);
        this.configure((IoService)this.connector);
        IoHandler handler = this.getHandler();
        this.log.debug("Handler: {}", (Object)handler);
        this.log.info("Connecting to: {}", (Object)this.remoteAddress);
        ConnectFuture cf = this.connector.connect(this.remoteAddress, this.localAddress, handler);
        this.log.debug("Waiting for connection to establish");
        cf.join();
        IoSession s = cf.getSession();
        this.session = new SessionAdapter(s);
        this.log.debug("Session: ", (Object)this.session);
        this.configure(s);
        TRANSPORT.bind(s, this);
        this.log.info("Connected to: {}", (Object)s.getRemoteAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            IoSession s = this.session.getSession();
            TRANSPORT.unbind(s);
            CloseFuture cf = s.close();
            cf.join();
        }
        finally {
            super.close();
        }
    }

    @Override
    public URI getRemote() {
        return this.remoteLocation;
    }

    @Override
    public URI getLocal() {
        return this.localLocation;
    }

    @Override
    public T getConnector() {
        return this.connector;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public void addListener(Transport.Listener listener) {
        assert (listener != null);
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeListener(Transport.Listener listener) {
        assert (listener != null);
        throw new UnsupportedOperationException();
    }

    protected static class BaseTransportConfiguration
    extends BaseConfiguration
    implements Transport.Configuration {
        protected BaseTransportConfiguration() {
        }
    }
}

