/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.obr;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.obr.ObrCommandSupport;
import org.osgi.service.obr.Capability;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resource;

@CommandComponent(id="obr:info", description="Display the meta-data for the specified bundles.")
public class InfoCommand
extends ObrCommandSupport {
    @Argument(required=true, multiValued=true)
    List<String> bundles;

    protected void doExecute(RepositoryAdmin admin) throws Exception {
        for (String bundle : this.bundles) {
            String[] target = this.getTarget(bundle);
            Resource[] resources = this.searchRepository(admin, target[0], target[1]);
            if (resources == null) {
                this.io.err.println("Unknown bundle and/or version: " + target[0]);
                continue;
            }
            for (int resIdx = 0; resIdx < resources.length; ++resIdx) {
                if (resIdx > 0) {
                    this.io.out.println("");
                }
                this.printResource(this.io.out, resources[resIdx]);
            }
        }
    }

    private void printResource(PrintWriter out, Resource resource) {
        Capability[] caps;
        this.printUnderline(out, resource.getPresentationName().length());
        out.println(resource.getPresentationName());
        this.printUnderline(out, resource.getPresentationName().length());
        Map map = resource.getProperties();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue().getClass().isArray()) {
                out.println(entry.getKey() + ":");
                for (int j = 0; j < Array.getLength(entry.getValue()); ++j) {
                    out.println("   " + Array.get(entry.getValue(), j));
                }
                continue;
            }
            out.println(entry.getKey() + ": " + entry.getValue());
        }
        Requirement[] reqs = resource.getRequirements();
        if (reqs != null && reqs.length > 0) {
            out.println("Requires:");
            for (int i = 0; i < reqs.length; ++i) {
                out.println("   " + reqs[i].getFilter());
            }
        }
        if ((caps = resource.getCapabilities()) != null && caps.length > 0) {
            out.println("Capabilities:");
            for (int i = 0; i < caps.length; ++i) {
                out.println("   " + caps[i].getProperties());
            }
        }
    }
}

