/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.obr;

import java.net.URL;
import java.util.List;
import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.obr.ObrCommandSupport;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.RepositoryAdmin;

@CommandComponent(id="obr:refreshUrl", description="Refresh a list of repository URLs to the repository service")
public class RefreshUrlCommand
extends ObrCommandSupport {
    @Argument(required=false, multiValued=true, description="Repository URLs (leave empty for all)")
    List<String> urls;

    protected void doExecute(RepositoryAdmin admin) throws Exception {
        block3: {
            block2: {
                if (this.urls == null && !this.urls.isEmpty()) break block2;
                for (String url : this.urls) {
                    admin.removeRepository(new URL(url));
                    admin.addRepository(new URL(url));
                }
                break block3;
            }
            Repository[] repos = admin.listRepositories();
            if (repos == null || repos.length <= 0) break block3;
            for (int i = 0; i < repos.length; ++i) {
                admin.removeRepository(repos[i].getURL());
                admin.addRepository(repos[i].getURL());
            }
        }
    }
}

