/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.pool;

import java.io.IOException;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.WrapperNamedXAResource;

public class ActiveMQResourceManager {
    private static final Log LOGGER = LogFactory.getLog(ActiveMQResourceManager.class);
    private String resourceName;
    private TransactionManager transactionManager;
    private ConnectionFactory connectionFactory;

    public void recoverResource() {
        try {
            if (!Recovery.recover(this)) {
                LOGGER.info((Object)"Resource manager is unrecoverable");
            }
        }
        catch (NoClassDefFoundError e) {
            LOGGER.info((Object)("Resource manager is unrecoverable due to missing classes: " + e));
        }
        catch (Throwable e) {
            LOGGER.warn((Object)"Error while recovering resource manager", e);
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public static class Recovery {
        public static boolean isRecoverable(ActiveMQResourceManager rm) {
            return rm.getConnectionFactory() instanceof ActiveMQConnectionFactory && rm.getTransactionManager() instanceof RecoverableTransactionManager && rm.getResourceName() != null && !"".equals(rm.getResourceName());
        }

        public static boolean recover(ActiveMQResourceManager rm) throws IOException {
            if (Recovery.isRecoverable(rm)) {
                try {
                    ActiveMQConnectionFactory connFactory = (ActiveMQConnectionFactory)rm.getConnectionFactory();
                    ActiveMQConnection activeConn = (ActiveMQConnection)connFactory.createConnection();
                    ActiveMQSession session = (ActiveMQSession)activeConn.createSession(true, 0);
                    WrapperNamedXAResource namedXaResource = new WrapperNamedXAResource((XAResource)session.getTransactionContext(), rm.getResourceName());
                    RecoverableTransactionManager rtxManager = (RecoverableTransactionManager)rm.getTransactionManager();
                    rtxManager.recoverResourceManager((NamedXAResource)namedXaResource);
                    return true;
                }
                catch (JMSException e) {
                    throw IOExceptionSupport.create((Exception)((Object)e));
                }
            }
            return false;
        }
    }
}

