/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.util.ChainReaderHelper;
import org.apache.tools.ant.types.FilterSetCollection;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.ResourceFactory;
import org.apache.tools.ant.types.TimeComparison;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.Touchable;
import org.apache.tools.ant.types.resources.Union;
import org.apache.tools.ant.types.resources.selectors.And;
import org.apache.tools.ant.types.resources.selectors.Date;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.Not;
import org.apache.tools.ant.types.resources.selectors.Or;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.types.resources.selectors.Type;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.LineTokenizer;

public class ResourceUtils {
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final ResourceSelector NOT_EXISTS = new Not(new Exists());

    public static Resource[] selectOutOfDateSources(ProjectComponent logTo, Resource[] source, FileNameMapper mapper, ResourceFactory targets) {
        return ResourceUtils.selectOutOfDateSources(logTo, source, mapper, targets, FILE_UTILS.getFileTimestampGranularity());
    }

    public static Resource[] selectOutOfDateSources(ProjectComponent logTo, Resource[] source, FileNameMapper mapper, ResourceFactory targets, long granularity) {
        Union u = new Union();
        u.addAll(Arrays.asList(source));
        ResourceCollection rc = ResourceUtils.selectOutOfDateSources(logTo, u, mapper, targets, granularity);
        return rc.size() == 0 ? new Resource[]{} : ((Union)rc).listResources();
    }

    public static ResourceCollection selectOutOfDateSources(ProjectComponent logTo, ResourceCollection source, FileNameMapper mapper, ResourceFactory targets, long granularity) {
        if (source.size() == 0) {
            logTo.log("No sources found.", 3);
            return Resources.NONE;
        }
        source = Union.getInstance(source);
        ResourceUtils.logFuture(logTo, source, granularity);
        Union result = new Union();
        Iterator iter = source.iterator();
        while (iter.hasNext()) {
            Resource sr = (Resource)iter.next();
            String srName = sr.getName();
            srName = srName == null ? srName : srName.replace('/', File.separatorChar);
            String[] targetnames = null;
            try {
                targetnames = mapper.mapFileName(srName);
            }
            catch (Exception e) {
                logTo.log("Caught " + e + " mapping resource " + sr, 3);
            }
            if (targetnames == null || targetnames.length == 0) {
                logTo.log(sr + " skipped - don't know how to handle it", 3);
                continue;
            }
            Union targetColl = new Union();
            for (int i = 0; i < targetnames.length; ++i) {
                targetColl.add(targets.getResource(targetnames[i].replace(File.separatorChar, '/')));
            }
            Restrict r = new Restrict();
            r.add(new And(new ResourceSelector[]{Type.FILE, new Or(new ResourceSelector[]{NOT_EXISTS, new Outdated(sr, granularity)})}));
            r.add(targetColl);
            if (r.size() > 0) {
                result.add(sr);
                Resource t = (Resource)r.iterator().next();
                logTo.log(sr.getName() + " added as " + t.getName() + (t.isExists() ? " is outdated." : " doesn't exist."), 3);
                continue;
            }
            logTo.log(sr.getName() + " omitted as " + targetColl.toString() + (targetColl.size() == 1 ? " is" : " are ") + " up to date.", 3);
        }
        return result;
    }

    public static void copyResource(Resource source, Resource dest) throws IOException {
        ResourceUtils.copyResource(source, dest, null);
    }

    public static void copyResource(Resource source, Resource dest, Project project) throws IOException {
        ResourceUtils.copyResource(source, dest, null, null, false, false, null, null, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResource(Resource source, Resource dest, FilterSetCollection filters, Vector filterChains, boolean overwrite, boolean preserveLastModified, String inputEncoding, String outputEncoding, Project project) throws IOException {
        block17: {
            block18: {
                boolean filterChainsAvailable;
                block16: {
                    if (!overwrite) {
                        long slm = source.getLastModified();
                        if (dest.isExists() && slm != 0L && dest.getLastModified() > slm) {
                            return;
                        }
                    }
                    boolean filterSetsAvailable = filters != null && filters.hasFilters();
                    boolean bl = filterChainsAvailable = filterChains != null && filterChains.size() > 0;
                    if (!filterSetsAvailable) break block16;
                    BufferedReader in = null;
                    BufferedWriter out = null;
                    try {
                        InputStreamReader isr = null;
                        isr = inputEncoding == null ? new InputStreamReader(source.getInputStream()) : new InputStreamReader(source.getInputStream(), inputEncoding);
                        in = new BufferedReader(isr);
                        OutputStreamWriter osw = null;
                        osw = outputEncoding == null ? new OutputStreamWriter(dest.getOutputStream()) : new OutputStreamWriter(dest.getOutputStream(), outputEncoding);
                        out = new BufferedWriter(osw);
                        if (filterChainsAvailable) {
                            ChainReaderHelper crh = new ChainReaderHelper();
                            crh.setBufferSize(8192);
                            crh.setPrimaryReader(in);
                            crh.setFilterChains(filterChains);
                            crh.setProject(project);
                            Reader rdr = crh.getAssembledReader();
                            in = new BufferedReader(rdr);
                        }
                        LineTokenizer lineTokenizer = new LineTokenizer();
                        lineTokenizer.setIncludeDelims(true);
                        String newline = null;
                        String line = lineTokenizer.getToken(in);
                        while (line != null) {
                            if (line.length() == 0) {
                                out.newLine();
                            } else {
                                newline = filters.replaceTokens(line);
                                out.write(newline);
                            }
                            line = lineTokenizer.getToken(in);
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.close(out);
                        FileUtils.close(in);
                        throw throwable;
                    }
                    FileUtils.close(out);
                    FileUtils.close(in);
                    break block17;
                }
                if (!filterChainsAvailable && (inputEncoding == null || inputEncoding.equals(outputEncoding)) && (inputEncoding != null || outputEncoding == null)) break block18;
                BufferedReader in = null;
                BufferedWriter out = null;
                try {
                    int nRead;
                    InputStreamReader isr = null;
                    isr = inputEncoding == null ? new InputStreamReader(source.getInputStream()) : new InputStreamReader(source.getInputStream(), inputEncoding);
                    in = new BufferedReader(isr);
                    OutputStreamWriter osw = null;
                    osw = outputEncoding == null ? new OutputStreamWriter(dest.getOutputStream()) : new OutputStreamWriter(dest.getOutputStream(), outputEncoding);
                    out = new BufferedWriter(osw);
                    if (filterChainsAvailable) {
                        ChainReaderHelper crh = new ChainReaderHelper();
                        crh.setBufferSize(8192);
                        crh.setPrimaryReader(in);
                        crh.setFilterChains(filterChains);
                        crh.setProject(project);
                        Reader rdr = crh.getAssembledReader();
                        in = new BufferedReader(rdr);
                    }
                    char[] buffer = new char[8192];
                    while ((nRead = in.read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, nRead);
                    }
                }
                catch (Throwable throwable) {
                    FileUtils.close(out);
                    FileUtils.close(in);
                    throw throwable;
                }
                FileUtils.close(out);
                FileUtils.close(in);
                break block17;
            }
            InputStream in = null;
            OutputStream out = null;
            try {
                in = source.getInputStream();
                out = dest.getOutputStream();
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = in.read(buffer, 0, buffer.length)) != -1);
            }
            catch (Throwable throwable) {
                FileUtils.close(out);
                FileUtils.close(in);
                throw throwable;
            }
            FileUtils.close(out);
            FileUtils.close(in);
        }
        if (preserveLastModified && dest instanceof Touchable) {
            ResourceUtils.setLastModified((Touchable)((Object)dest), source.getLastModified());
        }
    }

    public static void setLastModified(Touchable t, long time) {
        t.touch(time < 0L ? System.currentTimeMillis() : time);
    }

    public static boolean contentEquals(Resource r1, Resource r2, boolean text) throws IOException {
        if (r1.isExists() != r2.isExists()) {
            return false;
        }
        if (!r1.isExists()) {
            return true;
        }
        if (r1.isDirectory() || r2.isDirectory()) {
            return false;
        }
        if (r1.equals(r2)) {
            return true;
        }
        if (!text && r1.getSize() != r2.getSize()) {
            return false;
        }
        return ResourceUtils.compareContent(r1, r2, text) == 0;
    }

    public static int compareContent(Resource r1, Resource r2, boolean text) throws IOException {
        if (r1.equals(r2)) {
            return 0;
        }
        boolean e1 = r1.isExists();
        boolean e2 = r2.isExists();
        if (!e1 && !e2) {
            return 0;
        }
        if (e1 != e2) {
            return e1 ? 1 : -1;
        }
        boolean d1 = r1.isDirectory();
        boolean d2 = r2.isDirectory();
        if (d1 && d2) {
            return 0;
        }
        if (d1 || d2) {
            return d1 ? -1 : 1;
        }
        return text ? ResourceUtils.textCompare(r1, r2) : ResourceUtils.binaryCompare(r1, r2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int binaryCompare(Resource r1, Resource r2) throws IOException {
        block5: {
            in1 = null;
            in2 = null;
            try {
                in1 = new BufferedInputStream(r1.getInputStream());
                in2 = new BufferedInputStream(r2.getInputStream());
                b1 = in1.read();
lbl7:
                // 2 sources

                while (b1 != -1) {
                    b2 = in2.read();
                    if (b1 != b2) {
                        var6_6 = b1 > b2 ? 1 : -1;
                        break block5;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl24
            }
            catch (Throwable var7_7) {
                FileUtils.close(in1);
                FileUtils.close(in2);
                throw var7_7;
            }
        }
        FileUtils.close(in1);
        FileUtils.close(in2);
        return var6_6;
lbl-1000:
        // 1 sources

        {
            b1 = in1.read();
            ** GOTO lbl7
lbl24:
            // 1 sources

            var4_4 = in2.read() == -1 ? 0 : -1;
        }
        FileUtils.close(in1);
        FileUtils.close(in2);
        return var4_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int textCompare(Resource r1, Resource r2) throws IOException {
        int n;
        BufferedReader in2;
        BufferedReader in1;
        block5: {
            int n2;
            in1 = null;
            in2 = null;
            try {
                in1 = new BufferedReader(new InputStreamReader(r1.getInputStream()));
                in2 = new BufferedReader(new InputStreamReader(r2.getInputStream()));
                String expected = in1.readLine();
                while (expected != null) {
                    String actual = in2.readLine();
                    if (!expected.equals(actual)) {
                        n = expected.compareTo(actual);
                        break block5;
                    }
                    expected = in1.readLine();
                }
                n2 = in2.readLine() == null ? 0 : -1;
            }
            catch (Throwable throwable) {
                FileUtils.close(in1);
                FileUtils.close(in2);
                throw throwable;
            }
            FileUtils.close(in1);
            FileUtils.close(in2);
            return n2;
        }
        FileUtils.close(in1);
        FileUtils.close(in2);
        return n;
    }

    private static void logFuture(ProjectComponent logTo, ResourceCollection rc, long granularity) {
        long now = System.currentTimeMillis() + granularity;
        Date sel = new Date();
        sel.setMillis(now);
        sel.setWhen(TimeComparison.AFTER);
        Restrict future = new Restrict();
        future.add(sel);
        future.add(rc);
        Iterator iter = future.iterator();
        while (iter.hasNext()) {
            logTo.log("Warning: " + ((Resource)iter.next()).getName() + " modified in the future.", 1);
        }
    }

    private static final class Outdated
    implements ResourceSelector {
        private Resource control;
        private long granularity;

        private Outdated(Resource control, long granularity) {
            this.control = control;
            this.granularity = granularity;
        }

        public boolean isSelected(Resource r) {
            return SelectorUtils.isOutOfDate(this.control, r, this.granularity);
        }
    }
}

