/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.wsdl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Header;
import javax.wsdl.extensions.soap12.SOAP12HeaderFault;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import org.apache.servicemix.soap.api.Fault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLUtils {
    public static final String WSDL1_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    public static final String WSDL2_NAMESPACE = "http://www.w3.org/2006/01/wsdl";
    public static final String WSDL1_STYLE_RPC = "rpc";
    public static final String WSDL1_STYLE_DOCUMENT = "document";
    public static final String WSDL1_USE_LITERAL = "literal";
    private static WSDLFactory wsdl11Factory;

    public static WSDLReader createWSDL11Reader() {
        WSDLReader reader = WSDLUtils.getWSDL11Factory().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        return reader;
    }

    public static WSDLFactory getWSDL11Factory() {
        if (wsdl11Factory == null) {
            try {
                wsdl11Factory = WSDLFactory.newInstance();
            }
            catch (WSDLException e) {
                throw new Fault(e);
            }
        }
        return wsdl11Factory;
    }

    public static List<String> getParts(SOAPBody body) {
        return body.getParts();
    }

    public static List<String> getParts(SOAP12Body body) {
        return body.getParts();
    }

    public static Map<String, Part> getParts(Message msg) {
        return msg.getParts();
    }

    public static Collection<BindingFault> getBindingFaults(BindingOperation bop) {
        return bop.getBindingFaults().values();
    }

    public static List<SOAPHeaderFault> getSOAPHeaderFaults(SOAPHeader sh) {
        return sh.getSOAPHeaderFaults();
    }

    public static List<SOAP12HeaderFault> getSOAPHeaderFaults(SOAP12Header sh) {
        return sh.getSOAP12HeaderFaults();
    }

    public static List<ElementExtensible> getElements(BindingOperation bop) {
        ArrayList<ElementExtensible> l = new ArrayList<ElementExtensible>();
        l.add((ElementExtensible)bop);
        l.add((ElementExtensible)bop.getBindingInput());
        l.add((ElementExtensible)bop.getBindingOutput());
        l.addAll(WSDLUtils.getBindingFaults(bop));
        return l;
    }

    public static <T> T getExtension(ElementExtensible element, Class<T> format) {
        if (element != null) {
            for (Object ex : element.getExtensibilityElements()) {
                if (!format.isInstance(ex)) continue;
                return format.cast(ex);
            }
        }
        return null;
    }

    public static <T> List<T> getExtensions(ElementExtensible element, Class<T> format) {
        ArrayList<T> l = new ArrayList<T>();
        if (element != null) {
            for (Object ex : element.getExtensibilityElements()) {
                if (!format.isInstance(ex)) continue;
                l.add(format.cast(ex));
            }
        }
        return l;
    }

    public static <T> List<T> getExtensions(List<ElementExtensible> elements, Class<T> format) {
        ArrayList<T> l = new ArrayList<T>();
        for (ElementExtensible e : elements) {
            l.addAll(WSDLUtils.getExtensions(e, format));
        }
        return l;
    }
}

