/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.soap.wsdl.validator;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ElementExtensible;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.apache.servicemix.soap.util.QNameUtil;
import org.apache.servicemix.soap.wsdl.WSDLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSIBPValidator {
    private Definition definition;
    private Set<String> errors;
    private ResourceBundle bundle;

    public WSIBPValidator(Definition definition) {
        this.definition = definition;
        this.errors = new HashSet<String>();
        this.bundle = ResourceBundle.getBundle("org.apache.servicemix.soap.wsdl.validator.WSIBP");
    }

    protected void error(Code code, Binding binding) {
        this.error(code, "binding", QNameUtil.toString(binding.getQName()));
    }

    protected void error(Code code, PortType portType) {
        this.error(code, "port-type", QNameUtil.toString(portType.getQName()));
    }

    protected void error(Code code, Message message) {
        this.error(code, "message", QNameUtil.toString(message.getQName()));
    }

    protected void error(Code code, String locType, String loc) {
        StringBuffer buf = new StringBuffer();
        buf.append(locType);
        buf.append(" \"");
        buf.append(loc);
        buf.append("\" : ");
        buf.append("Basic Profile Violation #");
        buf.append((Object)code);
        buf.append(": ");
        buf.append(this.bundle.getString(code.toString()));
        this.errors.add(buf.toString());
    }

    public boolean isValid() {
        for (Method m : this.getClass().getMethods()) {
            if (!m.getName().startsWith("check")) continue;
            try {
                m.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.errors.size() == 0;
    }

    public Collection<String> getErrors() {
        return this.errors;
    }

    public void checkPortTypes() {
        for (PortType portType : this.definition.getPortTypes().values()) {
            HashSet<String> operationNames = new HashSet<String>();
            for (Operation operation : portType.getOperations()) {
                if (operation.getStyle() != OperationType.ONE_WAY && operation.getStyle() != OperationType.REQUEST_RESPONSE) {
                    this.error(Code.R2303, portType);
                }
                if (operationNames.add(operation.getName())) continue;
                this.error(Code.R2304, portType);
            }
        }
    }

    public void checkMessages() {
        for (Message msg : this.definition.getMessages().values()) {
            for (Part p : msg.getParts().values()) {
                if (p.getTypeName() == null || p.getElementName() == null) continue;
                this.error(Code.R2306, msg);
            }
        }
    }

    public void checkBindings() {
        for (Binding binding : this.definition.getBindings().values()) {
            SOAPBinding soapBinding = WSDLUtils.getExtension((ElementExtensible)binding, SOAPBinding.class);
            if (soapBinding == null) {
                this.error(Code.R2401, binding);
                continue;
            }
            if (soapBinding.getTransportURI() == null) {
                this.error(Code.R2701, binding);
            } else if (!"http://schemas.xmlsoap.org/soap/http".equals(soapBinding.getTransportURI())) {
                this.error(Code.R2702, binding);
            }
            for (BindingOperation bop : binding.getBindingOperations()) {
                if (this.ensureLiteral(bop)) continue;
                this.error(Code.R2706, binding);
                break;
            }
            Style bindingStyle = null;
            for (BindingOperation bop : binding.getBindingOperations()) {
                Style opStyle;
                SOAPOperation soapBop = WSDLUtils.getExtension((ElementExtensible)bop, SOAPOperation.class);
                Style style = opStyle = soapBop != null ? this.getStyle(soapBop.getStyle()) : null;
                if (opStyle == null && (opStyle = this.getStyle(soapBinding.getStyle())) == null) {
                    opStyle = Style.DOCUMENT;
                }
                if (bindingStyle == null) {
                    bindingStyle = opStyle;
                    continue;
                }
                if (bindingStyle == opStyle) continue;
                this.error(Code.R2705, binding);
                break;
            }
            if (bindingStyle == Style.DOCUMENT) {
                for (BindingOperation bop : binding.getBindingOperations()) {
                    this.validateDocLitBodyParts(binding, WSDLUtils.getExtension((ElementExtensible)bop.getBindingInput(), SOAPBody.class), bop.getOperation().getInput().getMessage());
                    this.validateDocLitBodyParts(binding, WSDLUtils.getExtension((ElementExtensible)bop.getBindingOutput(), SOAPBody.class), bop.getOperation().getOutput().getMessage());
                }
            }
            if (bindingStyle == Style.RPC) {
                // empty if block
            }
            for (BindingOperation bop : binding.getBindingOperations()) {
                this.validateHeaderParts(binding, WSDLUtils.getExtensions((ElementExtensible)bop.getBindingInput(), SOAPHeader.class), bop.getOperation().getInput().getMessage());
                if (bop.getOperation().getOutput() == null) continue;
                this.validateHeaderParts(binding, WSDLUtils.getExtensions((ElementExtensible)bop.getBindingOutput(), SOAPHeader.class), bop.getOperation().getOutput().getMessage());
            }
            if (bindingStyle == Style.DOCUMENT) {
                for (BindingOperation bop : binding.getBindingOperations()) {
                    if (this.ensureNamespace(bop, false, false) && this.ensureNamespace(bop, true, false)) continue;
                    this.error(Code.R2716, binding);
                    break;
                }
            }
            if (bindingStyle == Style.RPC) {
                for (BindingOperation bop : binding.getBindingOperations()) {
                    if (this.ensureNamespace(bop, true, true)) continue;
                    this.error(Code.R2717, binding);
                    break;
                }
            }
            if (bindingStyle == Style.RPC) {
                for (BindingOperation bop : binding.getBindingOperations()) {
                    if (this.ensureNamespace(bop, false, false)) continue;
                    this.error(Code.R2726, binding);
                    break;
                }
            }
            HashSet<String> opNames = new HashSet<String>();
            Iterator itOp = binding.getPortType().getOperations().iterator();
            while (itOp.hasNext()) {
                opNames.add(((Operation)itOp.next()).getName());
            }
            HashSet<String> bopNames = new HashSet<String>();
            Iterator itBop = binding.getBindingOperations().iterator();
            while (itBop.hasNext()) {
                bopNames.add(((BindingOperation)itBop.next()).getName());
            }
            if (!((Object)opNames).equals(bopNames)) {
                this.error(Code.R2718, binding);
            }
            for (BindingOperation bop : binding.getBindingOperations()) {
                List<ElementExtensible> els = WSDLUtils.getElements(bop);
                boolean error = false;
                for (SOAPHeader sh : WSDLUtils.getExtensions(els, SOAPHeader.class)) {
                    error |= sh.getPart() == null;
                    for (SOAPHeaderFault shf : WSDLUtils.getSOAPHeaderFaults(sh)) {
                        error |= shf.getPart() == null;
                    }
                }
                if (!error) continue;
                this.error(Code.R2720, binding);
            }
            for (BindingOperation bop : binding.getBindingOperations()) {
                for (BindingFault fault : WSDLUtils.getBindingFaults(bop)) {
                    for (SOAPFault sf : WSDLUtils.getExtensions((ElementExtensible)fault, SOAPFault.class)) {
                        if (sf.getName() == null) {
                            this.error(Code.R2721, binding);
                            continue;
                        }
                        if (sf.getName().equals(fault.getName())) continue;
                        this.error(Code.R2754, binding);
                    }
                }
            }
        }
    }

    private void validateHeaderParts(Binding binding, List<SOAPHeader> headers, Message message) {
        for (SOAPHeader sh : headers) {
            if (message.getPart(sh.getPart()).getElementName() == null) {
                this.error(Code.R2205, binding);
            }
            for (SOAPHeaderFault shf : WSDLUtils.getSOAPHeaderFaults(sh)) {
                if (message.getPart(shf.getPart()).getElementName() != null) continue;
                this.error(Code.R2205, binding);
            }
        }
    }

    private void validateDocLitBodyParts(Binding binding, SOAPBody body, Message message) {
        if (body != null) {
            if (body.getParts() == null) {
                if (message.getParts().size() > 1) {
                    this.error(Code.R2210, binding);
                }
            } else {
                if (body.getParts().size() > 1) {
                    this.error(Code.R2201, binding);
                }
                for (String p : WSDLUtils.getParts(body)) {
                    if (message.getPart(p).getElementName() != null) continue;
                    this.error(Code.R2204, binding);
                }
            }
        }
    }

    private boolean ensureLiteral(BindingOperation operation) {
        List<ElementExtensible> els = WSDLUtils.getElements(operation);
        for (SOAPBody sb : WSDLUtils.getExtensions(els, SOAPBody.class)) {
            if (sb.getUse() != null && "literal".equals(sb.getUse())) continue;
            return false;
        }
        for (SOAPHeader sh : WSDLUtils.getExtensions(els, SOAPHeader.class)) {
            if (sh.getUse() == null || !"literal".equals(sh.getUse())) {
                return false;
            }
            for (SOAPHeaderFault shf : WSDLUtils.getSOAPHeaderFaults(sh)) {
                if (shf.getUse() != null && "literal".equals(shf.getUse())) continue;
                return false;
            }
        }
        for (SOAPFault sf : WSDLUtils.getExtensions(els, SOAPFault.class)) {
            if (sf.getUse() != null && "literal".equals(sf.getUse())) continue;
            return false;
        }
        return true;
    }

    private boolean checkNullOrNonEmpty(String str, boolean isNonEmpty) {
        if (isNonEmpty) {
            if (str != null && str.length() > 0) {
                try {
                    return new URI(str).isAbsolute();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return false;
        }
        return str == null;
    }

    private boolean ensureNamespace(BindingOperation operation, boolean body, boolean set) {
        List<ElementExtensible> els = WSDLUtils.getElements(operation);
        if (body) {
            for (SOAPBody sb : WSDLUtils.getExtensions(els, SOAPBody.class)) {
                if (this.checkNullOrNonEmpty(sb.getNamespaceURI(), set)) continue;
                return false;
            }
        } else {
            for (SOAPHeader sh : WSDLUtils.getExtensions(els, SOAPHeader.class)) {
                if (!this.checkNullOrNonEmpty(sh.getNamespaceURI(), set)) {
                    return false;
                }
                for (SOAPHeaderFault shf : WSDLUtils.getSOAPHeaderFaults(sh)) {
                    if (this.checkNullOrNonEmpty(shf.getNamespaceURI(), set)) continue;
                    return false;
                }
            }
            for (SOAPFault sf : WSDLUtils.getExtensions(els, SOAPFault.class)) {
                if (this.checkNullOrNonEmpty(sf.getNamespaceURI(), set)) continue;
                return false;
            }
        }
        return true;
    }

    private Style getStyle(String str) {
        if ("document".equalsIgnoreCase(str)) {
            return Style.DOCUMENT;
        }
        if ("rpc".equalsIgnoreCase(str)) {
            return Style.RPC;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        RPC,
        DOCUMENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Code {
        R2201,
        R2204,
        R2205,
        R2210,
        R2303,
        R2304,
        R2306,
        R2401,
        R2701,
        R2702,
        R2705,
        R2706,
        R2710,
        R2716,
        R2717,
        R2718,
        R2720,
        R2721,
        R2726,
        R2754;

    }
}

