/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.jbi.interceptor;

import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.jbi.JBIConstants;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;

public class JBIWrapperOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIWrapperOutInterceptor.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public JBIWrapperOutInterceptor() {
        super("marshal");
    }

    public void handleMessage(Message message) throws Fault {
        BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        XMLStreamWriter xmlWriter = this.getXMLStreamWriter(message);
        Service service = (Service)message.getExchange().get(Service.class);
        DataWriter dataWriter = this.getDataWriter(message, service, XMLStreamWriter.class);
        try {
            xmlWriter.setPrefix("jbi", "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper");
            xmlWriter.writeStartElement("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", JBIConstants.JBI_WRAPPER_MESSAGE.getLocalPart());
            xmlWriter.writeNamespace("jbi", "http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper");
            this.setTypeAttr(xmlWriter, message);
            List parts = null;
            parts = !this.isRequestor(message) ? bop.getOutput().getMessageParts() : bop.getInput().getMessageParts();
            List objs = (List)message.getContent(List.class);
            if (objs.size() < parts.size()) {
                throw new Fault(new org.apache.cxf.common.i18n.Message("NOT_EQUAL_ARG_NUM", BUNDLE, new Object[0]));
            }
            for (int idx = 0; idx < parts.size(); ++idx) {
                MessagePartInfo part = (MessagePartInfo)parts.get(idx);
                Object obj = objs.get(part.getIndex());
                if (!part.isElement()) {
                    if (part.getTypeClass() == String.class) {
                        xmlWriter.writeStartElement("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", JBIConstants.JBI_WRAPPER_PART.getLocalPart());
                        xmlWriter.writeCharacters(obj.toString());
                        xmlWriter.writeEndElement();
                        continue;
                    }
                    part = new MessagePartInfo(part.getName(), part.getMessageInfo());
                    part.setElement(false);
                    part.setConcreteName(JBIConstants.JBI_WRAPPER_PART);
                    dataWriter.write(obj, part, (Object)xmlWriter);
                    continue;
                }
                xmlWriter.writeStartElement("http://java.sun.com/xml/ns/jbi/wsdl-11-wrapper", JBIConstants.JBI_WRAPPER_PART.getLocalPart());
                dataWriter.write(obj, part, (Object)xmlWriter);
                xmlWriter.writeEndElement();
            }
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("STAX_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)e);
        }
    }

    private void setTypeAttr(XMLStreamWriter xmlWriter, Message message) throws XMLStreamException {
        BindingOperationInfo wsdlOperation = this.getOperation(message);
        BindingMessageInfo wsdlMessage = this.isRequestor(message) ? wsdlOperation.getInput() : wsdlOperation.getOutput();
        String typeNamespace = wsdlMessage.getMessageInfo().getName().getNamespaceURI();
        if (typeNamespace == null || typeNamespace.length() == 0) {
            throw new IllegalArgumentException("messageType namespace is null or empty");
        }
        xmlWriter.writeAttribute("xmlns:msg", typeNamespace);
        String typeLocalName = wsdlMessage.getMessageInfo().getName().getLocalPart();
        if (typeLocalName == null || typeLocalName.length() == 0) {
            throw new IllegalArgumentException("messageType local name is null or empty");
        }
        xmlWriter.writeAttribute("type", "msg:" + typeLocalName);
    }

    protected BindingOperationInfo getOperation(Message message) {
        BindingOperationInfo operation = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        if (operation == null) {
            throw new Fault((Throwable)new Exception("Operation not bound on this message"));
        }
        return operation;
    }

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey((Object)"org.apache.cxf.client"));
    }
}

