/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.Map;
import org.drools.StatefulSession;
import org.drools.decisiontable.parser.Cell;
import org.drools.decisiontable.parser.Column;
import org.drools.decisiontable.parser.Row;

public class LongCell
implements Cell {
    Row row;
    Long value;
    Column column;
    private int index;

    public LongCell() {
    }

    LongCell(Row r, Column c) {
        this.row = r;
        this.column = c;
    }

    public String toString() {
        return "Cell[" + this.column + ": " + this.value + "]";
    }

    public Row getRow() {
        return this.row;
    }

    public Column getColumn() {
        return this.column;
    }

    public Long getValue() {
        return this.value;
    }

    public void addValue(Map vars) {
        vars.put(this.column.getName(), this.value);
    }

    public void insert(StatefulSession session) {
        session.insert(this);
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public void setValue(String v) {
        this.value = new Long(v);
    }

    public boolean isEmpty() {
        return this.value == null;
    }
}

