/*
 * Decompiled with CFR 0.152.
 */
package org.drools.lang.dsl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.lang.dsl.DSLMapping;
import org.drools.lang.dsl.DSLMappingEntry;
import org.drools.lang.dsl.DSLMappingParseException;
import org.drools.lang.dsl.DefaultDSLMapping;
import org.drools.lang.dsl.DefaultDSLMappingEntry;

public class DSLMappingFile {
    private static final Pattern pattern = Pattern.compile("((\\[[^\\[]*\\])\\s*(\\[([^\\[]*)\\])?)?\\s*((\\\\=|[^=])*)=(.*)");
    private static final String KEYWORD = "[keyword]";
    private static final String CONDITION = "[condition]";
    private static final String CONSEQUENCE = "[consequence]";
    private static final String WHEN = "[when]";
    private static final String THEN = "[then]";
    private DSLMapping mapping = new DefaultDSLMapping();
    private List errors = Collections.EMPTY_LIST;

    public DSLMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(DSLMapping mapping) {
        this.mapping = mapping;
    }

    public List getErrors() {
        return Collections.unmodifiableList(this.errors);
    }

    public boolean parseAndLoad(Reader dsl) throws IOException {
        String line = null;
        int linecounter = 0;
        BufferedReader dslFileReader = new BufferedReader(dsl);
        this.mapping = new DefaultDSLMapping();
        this.errors = new LinkedList();
        StringBuffer sb = new StringBuffer();
        boolean spacesAllowed = true;
        while ((line = dslFileReader.readLine()) != null) {
            ++linecounter;
            String trimmedline = line.trim();
            if (spacesAllowed && (trimmedline.length() == 0 || trimmedline.startsWith("#"))) continue;
            sb.append(trimmedline);
            if (sb.charAt(sb.length() - 1) == '\\') {
                sb.append(' ');
                spacesAllowed = false;
                continue;
            }
            String lineToParse = sb.toString();
            spacesAllowed = true;
            sb = new StringBuffer();
            Matcher mat = pattern.matcher(lineToParse);
            if (mat.matches()) {
                String sectionStr = mat.group(2);
                String metadataStr = mat.group(4);
                String key = mat.group(5).replaceAll("\\\\=", "=");
                String value = mat.group(7);
                DSLMappingEntry.Section section = DSLMappingEntry.ANY;
                if (KEYWORD.equals(sectionStr)) {
                    section = DSLMappingEntry.KEYWORD;
                } else if (CONDITION.equals(sectionStr) || WHEN.equals(sectionStr)) {
                    section = DSLMappingEntry.CONDITION;
                } else if (CONSEQUENCE.equals(sectionStr) || THEN.equals(sectionStr)) {
                    section = DSLMappingEntry.CONSEQUENCE;
                }
                DSLMappingEntry.MetaData metadata = metadataStr == null || metadataStr.length() == 0 ? DSLMappingEntry.EMPTY_METADATA : new DSLMappingEntry.DefaultDSLEntryMetaData(metadataStr);
                DefaultDSLMappingEntry entry = new DefaultDSLMappingEntry(section, metadata, key, value);
                this.mapping.addEntry(entry);
                continue;
            }
            String error = "Error parsing mapping entry: " + line;
            DSLMappingParseException exception = new DSLMappingParseException(error, linecounter);
            this.errors.add(exception);
        }
        return this.errors.isEmpty();
    }

    public void saveMapping(Writer out) throws IOException {
        Iterator it = this.mapping.getEntries().iterator();
        while (it.hasNext()) {
            out.write(it.next().toString());
            out.write("\n");
        }
    }

    public static void saveMapping(Writer out, DSLMapping mapping) throws IOException {
        Iterator it = mapping.getEntries().iterator();
        while (it.hasNext()) {
            out.write(it.next().toString());
            out.write("\n");
        }
    }

    public String dumpFile() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.mapping.getEntries().iterator();
        while (it.hasNext()) {
            buf.append(it.next());
            buf.append("\n");
        }
        return buf.toString();
    }
}

