/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import org.apache.log4j.Logger;
import org.drools.repository.RulesRepositoryException;

public class RulesRepositoryAdministrator {
    private static final Logger log = Logger.getLogger((Class)RulesRepositoryAdministrator.class);
    private final Session session;

    public RulesRepositoryAdministrator(Session session) {
        this.session = session;
    }

    static boolean isNamespaceRegistered(Session session) throws RepositoryException {
        Workspace ws = session.getWorkspace();
        String[] uris = ws.getNamespaceRegistry().getURIs();
        for (int i = 0; i < uris.length; ++i) {
            if (!"http://www.jboss.org/drools-repository/1.0".equals(uris[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isRepositoryInitialized() {
        try {
            return RulesRepositoryAdministrator.isNamespaceRegistered(this.session) && this.session.getRootNode().hasNode("drools:repository");
        }
        catch (RepositoryException e) {
            throw new RulesRepositoryException(e);
        }
    }

    public void clearRulesRepository() {
        log.debug((Object)("Clearing repository database. UserId=" + this.session.getUserID()));
        try {
            if (this.session.getRootNode().hasNode("drools:repository")) {
                System.out.println("Clearing rules repository");
                Node node = this.session.getRootNode().getNode("drools:repository");
                node.remove();
                this.session.save();
            } else {
                System.out.println("Repo not setup, ergo not clearing it !");
            }
        }
        catch (PathNotFoundException e) {
            log.error((Object)e);
        }
        catch (RepositoryException e) {
            log.error((Object)e);
        }
    }
}

