/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Collect;
import org.drools.rule.ContextEntry;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.drools.util.ArrayUtils;
import org.drools.util.Entry;
import org.drools.util.FactEntry;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class CollectNode
extends BetaNode
implements TupleSink,
ObjectSink {
    private static final long serialVersionUID = 400L;
    private final Collect collect;
    private final AlphaNodeFieldConstraint[] resultConstraints;
    private final BetaConstraints resultsBinder;
    private final boolean unwrapRightObject;

    public CollectNode(int id, TupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultsBinder, Collect collect, boolean unwrapRight, BuildContext context) {
        super(id, leftInput, rightInput, sourceBinder);
        this.resultsBinder = resultsBinder;
        this.resultConstraints = resultConstraints;
        this.collect = collect;
        this.unwrapRightObject = unwrapRight;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        Collection result = this.collect.instantiateResultObject();
        InternalFactHandle resultHandle = workingMemory.getFactHandleFactory().newFactHandle(result);
        CollectResult colresult = new CollectResult();
        colresult.handle = resultHandle;
        colresult.propagated = false;
        if (this.tupleMemoryEnabled) {
            memory.betaMemory.getTupleMemory().add(leftTuple);
            memory.betaMemory.getCreatedHandles().put(leftTuple, colresult, false);
        }
        Iterator it = memory.betaMemory.getFactHandleMemory().iterator(leftTuple);
        this.constraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        FactEntry entry = (FactEntry)it.next();
        while (entry != null) {
            InternalFactHandle handle = entry.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(memory.betaMemory.getContext(), handle.getObject())) {
                if (this.unwrapRightObject) {
                    handle = ((ReteTuple)handle.getObject()).getLastHandle();
                }
                result.add(handle.getObject());
            }
            entry = (FactEntry)it.next();
        }
        this.constraints.resetTuple(memory.betaMemory.getContext());
        boolean isAllowed = true;
        int length = this.resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(result, workingMemory, memory.alphaContexts[i])) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            this.resultsBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
            if (this.resultsBinder.isAllowedCachedLeft(memory.resultsContext, result)) {
                colresult.propagated = true;
                this.sink.propagateAssertTuple(leftTuple, resultHandle, context, workingMemory);
            }
            this.resultsBinder.resetTuple(memory.resultsContext);
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        if (memory.betaMemory.getTupleMemory().remove(leftTuple) == null) {
            return;
        }
        CollectResult result = (CollectResult)memory.betaMemory.getCreatedHandles().remove(leftTuple);
        InternalFactHandle handle = result.handle;
        if (result.propagated) {
            this.sink.propagateRetractTuple(leftTuple, handle, context, workingMemory);
            workingMemory.getFactHandleFactory().destroyFactHandle(handle);
        }
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getFactHandleMemory().add(handle);
        if (!this.tupleMemoryEnabled) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.betaMemory.getContext(), workingMemory, handle);
        Entry[] tuples = memory.betaMemory.getTupleMemory().toArray();
        for (int i = 0; i < tuples.length; ++i) {
            ReteTuple tuple = (ReteTuple)tuples[i];
            if (!this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), tuple)) continue;
            this.modifyTuple(true, tuple, handle, context, workingMemory);
        }
        this.constraints.resetFactHandle(memory.betaMemory.getContext());
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        if (!memory.betaMemory.getFactHandleMemory().remove(handle)) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.betaMemory.getContext(), workingMemory, handle);
        Entry[] tuples = memory.betaMemory.getTupleMemory().toArray();
        for (int i = 0; i < tuples.length; ++i) {
            ReteTuple tuple = (ReteTuple)tuples[i];
            if (!this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), tuple)) continue;
            this.modifyTuple(false, tuple, handle, context, workingMemory);
        }
        this.constraints.resetFactHandle(memory.betaMemory.getContext());
    }

    public void modifyTuple(boolean isAssert, ReteTuple leftTuple, InternalFactHandle handle, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        CollectResult result = (CollectResult)memory.betaMemory.getCreatedHandles().get(leftTuple);
        if (result.propagated) {
            this.sink.propagateRetractTuple(leftTuple, result.handle, context, workingMemory);
            result.propagated = false;
        }
        if (this.unwrapRightObject) {
            handle = ((ReteTuple)handle.getObject()).getLastHandle();
        }
        if (context.getType() == 0) {
            ((Collection)result.handle.getObject()).add(handle.getObject());
        } else if (context.getType() == 1) {
            ((Collection)result.handle.getObject()).remove(handle.getObject());
        } else if (context.getType() == 2 || context.getType() == 3 || context.getType() == 4) {
            if (isAssert) {
                ((Collection)result.handle.getObject()).add(handle.getObject());
            } else {
                ((Collection)result.handle.getObject()).remove(handle.getObject());
            }
        }
        boolean isAllowed = true;
        int length = this.resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(result.handle.getObject(), workingMemory, memory.alphaContexts[i])) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            this.resultsBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
            if (this.resultsBinder.isAllowedCachedLeft(memory.resultsContext, result.handle.getObject())) {
                result.propagated = true;
                this.sink.propagateAssertTuple(leftTuple, result.handle, context, workingMemory);
            }
            this.resultsBinder.resetTuple(memory.resultsContext);
        }
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.betaMemory.getCreatedHandles().iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            CollectResult result = (CollectResult)entry.getValue();
            sink.assertTuple(new ReteTuple((ReteTuple)entry.getKey(), result.handle), context, workingMemory);
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.collect.hashCode() ^ this.resultsBinder.hashCode() ^ ArrayUtils.hashCode(this.resultConstraints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof CollectNode)) {
            return false;
        }
        CollectNode other = (CollectNode)object;
        if (!(this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints))) {
            return false;
        }
        return this.collect.equals(other.collect) && this.resultsBinder.equals(other.resultsBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    public String toString() {
        return "[ " + this.getClass().getName() + "(" + this.id + ") ]";
    }

    public Object createMemory(RuleBaseConfiguration config) {
        CollectMemory memory = new CollectMemory();
        memory.betaMemory = this.constraints.createBetaMemory(config);
        memory.resultsContext = this.resultsBinder.createContext();
        memory.alphaContexts = new ContextEntry[this.resultConstraints.length];
        for (int i = 0; i < this.resultConstraints.length; ++i) {
            memory.alphaContexts[i] = this.resultConstraints[i].createContextEntry();
        }
        return memory;
    }

    private static class CollectResult
    implements Serializable {
        private static final long serialVersionUID = -3553891852449175844L;
        public InternalFactHandle handle;
        public boolean propagated;

        private CollectResult() {
        }
    }

    public static class CollectMemory
    implements Serializable {
        private static final long serialVersionUID = 400L;
        public BetaMemory betaMemory;
        public ContextEntry[] resultsContext;
        public ContextEntry[] alphaContexts;
    }
}

