/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import org.drools.common.BaseNode;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.CompositeObjectSinkAdapter;
import org.drools.reteoo.EmptyObjectSinkAdapter;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.SingleObjectSinkAdapter;
import org.drools.spi.PropagationContext;

public abstract class ObjectSource
extends BaseNode
implements Serializable {
    protected ObjectSinkPropagator sink;
    protected ObjectSource objectSource;
    private int alphaNodeHashingThreshold;

    ObjectSource(int id) {
        this(id, null, 3);
    }

    ObjectSource(int id, ObjectSource objectSource, int alphaNodeHashingThreshold) {
        super(id);
        this.objectSource = objectSource;
        this.alphaNodeHashingThreshold = alphaNodeHashingThreshold;
        this.sink = EmptyObjectSinkAdapter.getInstance();
    }

    protected void addObjectSink(ObjectSink objectSink) {
        if (this.sink instanceof EmptyObjectSinkAdapter) {
            this.sink = new SingleObjectSinkAdapter(objectSink);
        } else if (this.sink instanceof SingleObjectSinkAdapter) {
            CompositeObjectSinkAdapter sinkAdapter = new CompositeObjectSinkAdapter(this.alphaNodeHashingThreshold);
            sinkAdapter.addObjectSink(this.sink.getSinks()[0]);
            sinkAdapter.addObjectSink(objectSink);
            this.sink = sinkAdapter;
        } else {
            ((CompositeObjectSinkAdapter)this.sink).addObjectSink(objectSink);
        }
    }

    protected void removeObjectSink(ObjectSink objectSink) {
        if (this.sink instanceof EmptyObjectSinkAdapter) {
            throw new IllegalArgumentException("Cannot remove a sink, when the list of sinks is null");
        }
        if (this.sink instanceof SingleObjectSinkAdapter) {
            this.sink = EmptyObjectSinkAdapter.getInstance();
        } else {
            CompositeObjectSinkAdapter sinkAdapter = (CompositeObjectSinkAdapter)this.sink;
            sinkAdapter.removeObjectSink(objectSink);
            if (sinkAdapter.size() == 1) {
                this.sink = new SingleObjectSinkAdapter(sinkAdapter.getSinks()[0]);
            }
        }
    }

    public abstract void updateSink(ObjectSink var1, PropagationContext var2, InternalWorkingMemory var3);

    public ObjectSinkPropagator getSinkPropagator() {
        return this.sink;
    }

    public boolean isInUse() {
        return this.sink.size() > 0;
    }
}

