/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spi;

import java.lang.reflect.Method;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.base.ClassObjectType;
import org.drools.base.ValueType;
import org.drools.common.InternalWorkingMemory;
import org.drools.spi.Extractor;
import org.drools.spi.ObjectType;
import org.drools.util.ClassUtils;

public class GlobalExtractor
implements Extractor {
    private static final long serialVersionUID = 400L;
    private final String key;
    private final ObjectType objectType;

    public GlobalExtractor(String key, Map map) {
        this.key = key;
        this.objectType = new ClassObjectType((Class)map.get(this.key));
    }

    public Object getValue(InternalWorkingMemory workingMemory, Object object) {
        return workingMemory.getGlobal(this.key);
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public Class getExtractToClass() {
        return this.objectType.getValueType().getClassType();
    }

    public String getExtractToClassName() {
        return ClassUtils.canonicalName(this.objectType.getValueType().getClassType());
    }

    public ValueType getValueType() {
        return this.objectType.getValueType();
    }

    public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isBoolean()) {
            return (Boolean)workingMemory.getGlobal(this.key);
        }
        throw new ClassCastException("Not possible to convert global '" + this.key + "' into a boolean.");
    }

    public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.key)).byteValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.key + "' into a byte.");
    }

    public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isChar()) {
            return ((Character)workingMemory.getGlobal(this.key)).charValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.key + "' into a char.");
    }

    public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.key)).doubleValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.key + "' into a double.");
    }

    public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.key)).floatValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.key + "' into a float.");
    }

    public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.key)).intValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.key + "' into an int.");
    }

    public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.key)).longValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.key + "' into a long.");
    }

    public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
        if (this.objectType.getValueType().isNumber()) {
            return ((Number)workingMemory.getGlobal(this.key)).shortValue();
        }
        throw new ClassCastException("Not possible to convert global '" + this.key + "' into a short.");
    }

    public Method getNativeReadMethod() {
        try {
            return this.getClass().getDeclaredMethod("getValue", InternalWorkingMemory.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
        Object value = this.getValue(workingMemory, object);
        return value != null ? value.hashCode() : 0;
    }

    public int hashCode() {
        return this.objectType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GlobalExtractor)) {
            return false;
        }
        GlobalExtractor other = (GlobalExtractor)obj;
        return (this.key == null ? other.key == null : this.key.equals(other.key)) && (this.objectType == null ? other.objectType == null : this.objectType.equals(other.objectType));
    }

    public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
        Object value = this.getValue(workingMemory, object);
        return value == null;
    }

    public boolean isGlobal() {
        return true;
    }
}

