/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.integration.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.mvel.ParserContext;
import org.mvel.integration.VariableResolver;
import org.mvel.integration.impl.BaseVariableResolverFactory;
import org.mvel.integration.impl.StaticMethodImportResolver;
import org.mvel.util.MethodStub;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticMethodImportResolverFactory
extends BaseVariableResolverFactory {
    public StaticMethodImportResolverFactory(ParserContext ctx) {
        this();
        Map<String, Object> imports = ctx.getImports();
        for (String name : imports.keySet()) {
            if (!(imports.get(name) instanceof Method)) continue;
            this.createVariable(name, imports.get(name));
        }
    }

    public StaticMethodImportResolverFactory() {
        this.variableResolvers = new HashMap();
    }

    @Override
    public VariableResolver createVariable(String name, Object value) {
        if (value instanceof Method) {
            value = new MethodStub((Method)value);
        }
        StaticMethodImportResolver methodResolver = new StaticMethodImportResolver(name, (MethodStub)value);
        this.variableResolvers.put(name, methodResolver);
        return methodResolver;
    }

    @Override
    public VariableResolver createVariable(String name, Object value, Class<?> type) {
        return null;
    }

    @Override
    public boolean isTarget(String name) {
        return this.variableResolvers.containsKey(name);
    }

    @Override
    public boolean isResolveable(String name) {
        return this.isTarget(name) || this.isNextResolveable(name);
    }

    public Map<String, Method> getImportedMethods() {
        HashMap<String, Method> im = new HashMap<String, Method>();
        for (String name : this.variableResolvers.keySet()) {
            im.put(name, (Method)((VariableResolver)this.variableResolvers.get(name)).getValue());
        }
        return im;
    }
}

