/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Map;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.servicemix.expression.Expression;
import org.apache.servicemix.http.endpoints.HttpProviderMarshaler;
import org.apache.servicemix.http.jetty.SmxHttpExchange;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StAXSourceTransformer;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.jetty.HttpHeaders;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpProviderMarshaler
implements HttpProviderMarshaler {
    private SourceTransformer transformer = new StAXSourceTransformer();
    private String locationURI;
    private Expression locationURIExpression;
    private String method;
    private Expression methodExpression;
    private String contentType = "text/xml";
    private Expression contentTypeExpression;
    private Map<String, String> headers;

    public String getLocationURI() {
        return this.locationURI;
    }

    public void setLocationURI(String locationUri) {
        this.locationURI = locationUri;
    }

    public Expression getLocationURIExpression() {
        return this.locationURIExpression;
    }

    public void setLocationURIExpression(Expression locationUriExpression) {
        this.locationURIExpression = locationUriExpression;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Expression getMethodExpression() {
        return this.methodExpression;
    }

    public void setMethodExpression(Expression methodExpression) {
        this.methodExpression = methodExpression;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Expression getContentTypeExpression() {
        return this.contentTypeExpression;
    }

    public void setContentTypeExpression(Expression contentTypeExpression) {
        this.contentTypeExpression = contentTypeExpression;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    protected String getLocationUri(MessageExchange exchange, NormalizedMessage inMsg) throws Exception {
        String uri = null;
        if (this.locationURIExpression != null) {
            Object o = this.locationURIExpression.evaluate(exchange, inMsg);
            String string = uri = o != null ? o.toString() : null;
        }
        if (uri == null) {
            uri = this.locationURI;
        }
        if (uri == null) {
            throw new IllegalStateException("Unable to find URI for exchange");
        }
        return uri;
    }

    protected String getMethod(MessageExchange exchange, NormalizedMessage inMsg) throws Exception {
        String mth = null;
        if (this.methodExpression != null) {
            Object o = this.methodExpression.evaluate(exchange, inMsg);
            String string = mth = o != null ? o.toString() : null;
        }
        if (mth == null) {
            mth = this.method;
        }
        if (mth == null) {
            mth = inMsg.getContent() == null ? "GET" : "POST";
        }
        return mth;
    }

    protected String getContentType(MessageExchange exchange, NormalizedMessage inMsg) throws Exception {
        String content = null;
        if (this.contentTypeExpression != null) {
            Object o = this.contentTypeExpression.evaluate(exchange, inMsg);
            String string = content = o != null ? o.toString() : null;
        }
        if (content == null) {
            content = this.contentType;
        }
        if (content == null) {
            throw new IllegalStateException("ContentType must not be null");
        }
        return content;
    }

    @Override
    public void createRequest(MessageExchange exchange, NormalizedMessage inMsg, SmxHttpExchange httpExchange) throws Exception {
        httpExchange.setURL(this.getLocationUri(exchange, inMsg));
        httpExchange.addRequestHeader(HttpHeaders.HOST_BUFFER, (Buffer)new ByteArrayBuffer(new URI(this.getLocationUri(exchange, inMsg)).getHost()));
        httpExchange.setMethod(this.getMethod(exchange, inMsg));
        httpExchange.setRequestHeader("Content-Type", this.getContentType(exchange, inMsg));
        if (this.getHeaders() != null) {
            for (Map.Entry<String, String> e : this.getHeaders().entrySet()) {
                httpExchange.setRequestHeader(e.getKey(), e.getValue());
            }
        }
        if (inMsg.getContent() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.transformer.toResult(inMsg.getContent(), (Result)new StreamResult(baos));
            httpExchange.setRequestContent((Buffer)new ByteArrayBuffer(baos.toByteArray()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleResponse(MessageExchange exchange, SmxHttpExchange httpExchange) throws Exception {
        int response = httpExchange.getResponseStatus();
        if (response != 200 && response != 202) {
            if (exchange instanceof InOnly) throw new Exception("Invalid status response: " + response);
            Fault fault = exchange.createFault();
            fault.setContent((Source)new StreamSource(httpExchange.getResponseReader()));
            exchange.setFault(fault);
            return;
        } else if (exchange instanceof InOut) {
            NormalizedMessage msg = exchange.createMessage();
            msg.setContent((Source)new StreamSource(httpExchange.getResponseReader()));
            exchange.setMessage(msg, "out");
            return;
        } else if (exchange instanceof InOptionalOut) {
            Reader r = httpExchange.getResponseReader();
            if (r != null) {
                NormalizedMessage msg = exchange.createMessage();
                msg.setContent((Source)new StreamSource(r));
                exchange.setMessage(msg, "out");
                return;
            } else {
                exchange.setStatus(ExchangeStatus.DONE);
            }
            return;
        } else {
            exchange.setStatus(ExchangeStatus.DONE);
        }
    }

    @Override
    public void handleException(MessageExchange exchange, SmxHttpExchange httpExchange, Throwable ex) {
        exchange.setError((Exception)ex);
    }
}

