/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.http.endpoints;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.jbi.component.ComponentContext;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.http.endpoints.DefaultHttpConsumerMarshaler;
import org.apache.servicemix.jbi.jaxp.SourceTransformer;
import org.apache.servicemix.jbi.jaxp.StringSource;

public class SerializedMarshaler
extends DefaultHttpConsumerMarshaler {
    private static Log log = LogFactory.getLog(SerializedMarshaler.class);

    public MessageExchange createExchange(HttpServletRequest request, ComponentContext context) throws Exception {
        MessageExchange me = context.getDeliveryChannel().createExchangeFactory().createExchange(this.getDefaultMep());
        NormalizedMessage in = me.createMessage();
        in.setContent(this.marshal((InputStream)request.getInputStream()));
        me.setMessage(in, "in");
        return me;
    }

    public void sendOut(MessageExchange exchange, NormalizedMessage outMsg, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (outMsg.getContent() != null) {
            this.unmarshal((OutputStream)response.getOutputStream(), outMsg.getContent());
        }
    }

    private Source marshal(InputStream is) throws IOException, ClassNotFoundException {
        Object obj = new ObjectInputStream(is).readObject();
        StringWriter w = new StringWriter();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xstream.toXML(obj, (Writer)w);
        String request = ((Object)w).toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remote invocation request: " + request));
        }
        return new StringSource(request);
    }

    private void unmarshal(OutputStream os, Source content) throws TransformerException, IOException {
        SourceTransformer transform = new SourceTransformer();
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
        String result = transform.toString(content);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Remote invocation result: " + result));
        }
        Object obj = xstream.fromXML(result);
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(obj);
    }
}

