/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.mail;

import java.util.Properties;
import javax.jbi.JBIException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import javax.mail.search.FlagTerm;
import javax.mail.search.SearchTerm;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.endpoints.PollingEndpoint;
import org.apache.servicemix.mail.MailEndpointType;
import org.apache.servicemix.mail.marshaler.AbstractMailMarshaler;
import org.apache.servicemix.mail.marshaler.DefaultMailMarshaler;
import org.apache.servicemix.mail.utils.MailConnectionConfiguration;
import org.apache.servicemix.mail.utils.MailUtils;

public class MailPollerEndpoint
extends PollingEndpoint
implements MailEndpointType {
    private static final transient Log LOG = LogFactory.getLog(MailPollerEndpoint.class);
    private AbstractMailMarshaler marshaler = new DefaultMailMarshaler();
    private String customTrustManagers;
    private MailConnectionConfiguration config;
    private String connection;
    private int maxFetchSize = 5;
    private boolean processOnlyUnseenMessages = true;
    private boolean deleteProcessedMessages = false;
    private boolean debugMode = false;

    public String getLocationURI() {
        return this.getService() + "#" + this.getEndpoint();
    }

    public void process(MessageExchange arg0) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void poll() throws Exception {
        LOG.debug((Object)("Polling mailfolder " + this.config.getFolderName() + " at host " + this.config.getHost() + "..."));
        if (this.maxFetchSize == 0) {
            LOG.debug((Object)"The configuration is set to poll no new messages at all...skipping.");
            return;
        }
        Store store = null;
        Folder folder = null;
        Session session = null;
        try {
            Properties props = MailUtils.getPropertiesForProtocol(this.config, this.customTrustManagers);
            props.put("mail.debug", this.isDebugMode() ? "true" : "false");
            session = Session.getInstance((Properties)props, (Authenticator)this.config.getAuthenticator());
            session.setDebug(this.debugMode);
            store = session.getStore(this.config.getProtocol());
            store.connect(this.config.getHost(), this.config.getUsername(), this.config.getPassword());
            folder = store.getFolder(this.config.getFolderName());
            if (folder == null || !folder.exists()) {
                throw new Exception("Folder not found or invalid: " + this.config.getFolderName());
            }
            folder.open(2);
            Message[] messages = null;
            messages = this.isProcessOnlyUnseenMessages() ? folder.search((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false)) : folder.getMessages();
            int fetchSize = this.getMaxFetchSize() == -1 ? messages.length : Math.min(this.getMaxFetchSize(), messages.length);
            for (int cnt = 0; cnt < fetchSize; ++cnt) {
                MimeMessage mailMsg = (MimeMessage)messages[cnt];
                InOnly io = this.getExchangeFactory().createInOnlyExchange();
                this.configureExchangeTarget((MessageExchange)io);
                NormalizedMessage normalizedMessage = io.createMessage();
                this.marshaler.convertMailToJBI((MessageExchange)io, normalizedMessage, mailMsg);
                io.setInMessage(normalizedMessage);
                this.sendSync((MessageExchange)io);
                if (io.getStatus() == ExchangeStatus.ERROR) {
                    Throwable e = io.getError();
                    if (e == null) {
                        e = new JBIException("Unexpected error occured...");
                    }
                    throw e;
                }
                if (this.deleteProcessedMessages) {
                    mailMsg.setFlag(Flags.Flag.DELETED, true);
                    continue;
                }
                mailMsg.setFlag(Flags.Flag.SEEN, true);
            }
        }
        finally {
            try {
                if (folder != null) {
                    folder.close(true);
                }
                if (store != null) {
                    store.close();
                }
            }
            catch (Exception ignored) {
                this.logger.debug((Object)ignored);
            }
        }
    }

    public boolean isDeleteProcessedMessages() {
        return this.deleteProcessedMessages;
    }

    public void setDeleteProcessedMessages(boolean deleteProcessedMessages) {
        this.deleteProcessedMessages = deleteProcessedMessages;
    }

    public AbstractMailMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(AbstractMailMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public boolean isProcessOnlyUnseenMessages() {
        return this.processOnlyUnseenMessages;
    }

    public void setProcessOnlyUnseenMessages(boolean processOnlyUnseenMessages) {
        this.processOnlyUnseenMessages = processOnlyUnseenMessages;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
        try {
            this.config = MailUtils.configure(this.connection);
        }
        catch (ParseException ex) {
            LOG.error((Object)"The configured connection uri is invalid", (Throwable)ex);
        }
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getCustomTrustManagers() {
        return this.customTrustManagers;
    }

    public void setCustomTrustManagers(String customTrustManagers) {
        this.customTrustManagers = customTrustManagers;
    }
}

