/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.mail;

import java.util.Properties;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.ParseException;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.servicemix.common.endpoints.ProviderEndpoint;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.mail.MailEndpointType;
import org.apache.servicemix.mail.marshaler.AbstractMailMarshaler;
import org.apache.servicemix.mail.marshaler.DefaultMailMarshaler;
import org.apache.servicemix.mail.utils.MailConnectionConfiguration;
import org.apache.servicemix.mail.utils.MailUtils;

public class MailSenderEndpoint
extends ProviderEndpoint
implements MailEndpointType {
    private static final transient Log LOG = LogFactory.getLog(MailSenderEndpoint.class);
    private AbstractMailMarshaler marshaler = new DefaultMailMarshaler();
    private MailConnectionConfiguration config;
    private String customTrustManagers;
    private String connection;
    private String sender;
    private String receiver;
    private boolean debugMode;

    public void validate() throws DeploymentException {
        super.validate();
        if (this.config == null || this.connection == null) {
            throw new DeploymentException("No valid connection uri provided.");
        }
        if (this.sender == null) {
            this.sender = this.marshaler != null ? this.marshaler.getDefaultSenderForOutgoingMails() : "no-reply@localhost";
        }
    }

    protected void processInOnly(MessageExchange exchange, NormalizedMessage in) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (exchange.getFault() != null) {
            exchange.setStatus(ExchangeStatus.DONE);
            this.getChannel().send(exchange);
        } else {
            Session session = null;
            try {
                Properties props = MailUtils.getPropertiesForProtocol(this.config, this.customTrustManagers);
                props.put("mail.debug", this.isDebugMode() ? "true" : "false");
                session = Session.getInstance((Properties)props, (Authenticator)this.config.getAuthenticator());
                session.setDebug(this.debugMode);
                Transport transport = session.getTransport(this.config.getProtocol());
                transport.connect(this.config.getHost(), this.config.getPort(), this.config.getUsername(), this.config.getPassword());
                MimeMessage msg = new MimeMessage(session);
                this.marshaler.convertJBIToMail(msg, exchange, in, this.sender, this.receiver);
                transport.sendMessage((Message)msg, msg.getAllRecipients());
                transport.close();
            }
            catch (MessagingException mex) {
                this.logger.error((Object)"Error sending mail...", (Throwable)mex);
                throw mex;
            }
            finally {
                this.marshaler.cleanUpResources(exchange.getExchangeId());
            }
        }
    }

    protected void processInOut(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        if (exchange.getStatus() == ExchangeStatus.DONE) {
            return;
        }
        if (exchange.getStatus() == ExchangeStatus.ERROR) {
            return;
        }
        if (exchange.getFault() != null) {
            exchange.setStatus(ExchangeStatus.DONE);
            this.getChannel().send(exchange);
        } else {
            Session session = null;
            try {
                Properties props = MailUtils.getPropertiesForProtocol(this.config, this.customTrustManagers);
                props.put("mail.debug", this.isDebugMode() ? "true" : "false");
                session = Session.getInstance((Properties)props, (Authenticator)this.config.getAuthenticator());
                session.setDebug(this.debugMode);
                Transport transport = session.getTransport(this.config.getProtocol());
                transport.connect(this.config.getHost(), this.config.getPort(), this.config.getUsername(), this.config.getPassword());
                MimeMessage msg = new MimeMessage(session);
                this.marshaler.convertJBIToMail(msg, exchange, in, this.sender, this.receiver);
                transport.sendMessage((Message)msg, msg.getAllRecipients());
                transport.close();
                out.setContent((Source)new StringSource("<ack />"));
            }
            catch (MessagingException mex) {
                this.logger.error((Object)"Error sending mail...", (Throwable)mex);
                throw mex;
            }
            finally {
                this.marshaler.cleanUpResources(exchange.getExchangeId());
            }
        }
    }

    public AbstractMailMarshaler getMarshaler() {
        return this.marshaler;
    }

    public void setMarshaler(AbstractMailMarshaler marshaler) {
        this.marshaler = marshaler;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
        try {
            this.config = MailUtils.configure(this.connection);
        }
        catch (ParseException ex) {
            LOG.error((Object)"The configured connection uri is invalid", (Throwable)ex);
        }
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public String getCustomTrustManagers() {
        return this.customTrustManagers;
    }

    public void setCustomTrustManagers(String customTrustManagers) {
        this.customTrustManagers = customTrustManagers;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }
}

