/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.gshell.osgi;

import org.apache.geronimo.gshell.clp.Argument;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.osgi.BundleCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;

@CommandComponent(id="osgi:bundle-level", description="Get or set the start level of a given bundle")
public class BundleLevel
extends BundleCommand {
    @Argument(required=false, index=1)
    Integer level;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(Bundle bundle) throws Exception {
        ServiceReference ref = this.getBundleContext().getServiceReference(StartLevel.class.getName());
        if (ref == null) {
            this.io.out.println("StartLevel service is unavailable.");
            return;
        }
        try {
            StartLevel sl = (StartLevel)this.getBundleContext().getService(ref);
            if (sl == null) {
                this.io.out.println("StartLevel service is unavailable.");
                return;
            }
            if (this.level == null) {
                this.io.out.println("Level " + sl.getBundleStartLevel(bundle));
            } else {
                sl.setBundleStartLevel(bundle, this.level.intValue());
            }
        }
        finally {
            this.getBundleContext().ungetService(ref);
        }
    }
}

