/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.gshell.features.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.servicemix.gshell.features.Feature;
import org.apache.servicemix.gshell.features.Repository;
import org.apache.servicemix.gshell.features.internal.FeatureImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RepositoryImpl
implements Repository {
    private URI uri;
    private List<Feature> features;

    public RepositoryImpl(URI uri) {
        this.uri = uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public Feature[] getFeatures() throws Exception {
        if (this.features == null) {
            this.load();
        }
        return this.features.toArray(new Feature[this.features.size()]);
    }

    public void load() throws IOException {
        try {
            this.features = new ArrayList<Feature>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(this.uri.toURL().openStream());
            NodeList nodes = doc.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!(node instanceof Element) || !"feature".equals(node.getNodeName())) continue;
                Element e = (Element)nodes.item(i);
                String name = e.getAttribute("name");
                FeatureImpl f = new FeatureImpl(name);
                String version = e.getAttribute("version");
                if (version != null && version.length() > 0) {
                    f.setVersion(version);
                }
                NodeList featureNodes = e.getElementsByTagName("feature");
                for (int j = 0; j < featureNodes.getLength(); ++j) {
                    Element b = (Element)featureNodes.item(j);
                    f.addDependency(b.getTextContent());
                }
                NodeList configNodes = e.getElementsByTagName("config");
                for (int j = 0; j < configNodes.getLength(); ++j) {
                    Element c = (Element)configNodes.item(j);
                    String cfgName = c.getAttribute("name");
                    String data = c.getTextContent();
                    Properties properties = new Properties();
                    properties.load(new ByteArrayInputStream(data.getBytes()));
                    Hashtable<String, String> hashtable = new Hashtable<String, String>();
                    for (Object key : properties.keySet()) {
                        String n = key.toString();
                        hashtable.put(n, properties.getProperty(n));
                    }
                    f.addConfig(cfgName, hashtable);
                }
                NodeList bundleNodes = e.getElementsByTagName("bundle");
                for (int j = 0; j < bundleNodes.getLength(); ++j) {
                    Element b = (Element)bundleNodes.item(j);
                    f.addBundle(b.getTextContent());
                }
                this.features.add(f);
            }
        }
        catch (SAXException e) {
            throw (IOException)new IOException().initCause(e);
        }
        catch (ParserConfigurationException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }
}

