/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Consume;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointInject;
import org.apache.camel.MessageDriven;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Produce;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.util.ReflectionUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="beanPostProcessor")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final transient Log LOG = LogFactory.getLog(CamelBeanPostProcessor.class);
    @XmlTransient
    private SpringCamelContext camelContext;
    @XmlTransient
    private ApplicationContext applicationContext;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.injectFields(bean);
        this.injectMethods(bean);
        if (bean instanceof CamelContextAware) {
            CamelContextAware contextAware = (CamelContextAware)bean;
            if (this.camelContext == null) {
                LOG.warn((Object)("No CamelContext defined yet so cannot inject into: " + bean));
            } else {
                contextAware.setCamelContext((CamelContext)this.camelContext);
            }
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public SpringCamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(SpringCamelContext camelContext) {
        this.camelContext = camelContext;
    }

    protected void injectFields(final Object bean) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                Produce produce;
                EndpointInject annotation = field.getAnnotation(EndpointInject.class);
                if (annotation != null) {
                    CamelBeanPostProcessor.this.injectField(field, annotation.uri(), annotation.name(), bean);
                }
                if ((produce = field.getAnnotation(Produce.class)) != null) {
                    CamelBeanPostProcessor.this.injectField(field, produce.uri(), produce.ref(), bean);
                }
            }
        });
    }

    protected void injectField(Field field, String endpointUri, String endpointRef, Object bean) {
        ReflectionUtils.setField(field, bean, this.getInjectionValue(field.getType(), endpointUri, endpointRef, field.getName()));
    }

    protected void injectMethods(final Object bean) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                CamelBeanPostProcessor.this.setterInjection(method, bean);
                CamelBeanPostProcessor.this.consumerInjection(method, bean);
            }
        });
    }

    protected void setterInjection(Method method, Object bean) {
        Produce produce;
        EndpointInject annoation = method.getAnnotation(EndpointInject.class);
        if (annoation != null) {
            this.setterInjection(method, bean, annoation.uri(), annoation.name());
        }
        if ((produce = method.getAnnotation(Produce.class)) != null) {
            this.setterInjection(method, bean, produce.uri(), produce.ref());
        }
    }

    protected void setterInjection(Method method, Object bean, String endpointUri, String endpointRef) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes != null) {
            if (parameterTypes.length != 1) {
                LOG.warn((Object)("Ignoring badly annotated method for injection due to incorrect number of parameters: " + method));
            } else {
                String propertyName = ObjectHelper.getPropertyName((Method)method);
                Object value = this.getInjectionValue(parameterTypes[0], endpointUri, endpointRef, propertyName);
                ObjectHelper.invokeMethod((Method)method, (Object)bean, (Object[])new Object[]{value});
            }
        }
    }

    protected void consumerInjection(Object bean) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            }
        });
    }

    protected void consumerInjection(Method method, Object bean) {
        Consume consume;
        MessageDriven annotation = method.getAnnotation(MessageDriven.class);
        if (annotation != null) {
            LOG.info((Object)("Creating a consumer for: " + annotation));
            this.subscribeMethod(method, bean, annotation.uri(), annotation.name());
        }
        if ((consume = method.getAnnotation(Consume.class)) != null) {
            LOG.info((Object)("Creating a consumer for: " + consume));
            this.subscribeMethod(method, bean, consume.uri(), consume.ref());
        }
    }

    protected void subscribeMethod(Method method, Object bean, String endpointUri, String endpointName) {
        String injectionPointName = method.getName();
        Endpoint endpoint = this.getEndpointInjection(endpointUri, endpointName, injectionPointName);
        if (endpoint != null) {
            try {
                Processor processor = this.createConsumerProcessor(bean, method, endpoint);
                LOG.info((Object)("Created processor: " + processor));
                Consumer consumer = endpoint.createConsumer(processor);
                this.startService((Service)consumer);
            }
            catch (Exception e) {
                LOG.warn((Object)e);
                throw new RuntimeCamelException((Throwable)e);
            }
        }
    }

    protected void startService(Service service) throws Exception {
        this.camelContext.addService(service);
    }

    protected Processor createConsumerProcessor(Object pojo, Method method, Endpoint endpoint) {
        BeanProcessor answer = new BeanProcessor(pojo, (CamelContext)this.getCamelContext());
        answer.setMethodObject(method);
        return answer;
    }

    protected Object getInjectionValue(Class<?> type, String endpointUri, String endpointRef, String injectionPointName) {
        Endpoint endpoint = this.getEndpointInjection(endpointUri, endpointRef, injectionPointName);
        if (endpoint != null) {
            if (type.isInstance(endpoint)) {
                return endpoint;
            }
            if (type.isAssignableFrom(Producer.class)) {
                return this.createInjectionProducer(endpoint);
            }
            if (type.isAssignableFrom(DefaultProducerTemplate.class)) {
                return new DefaultProducerTemplate((CamelContext)this.getCamelContext(), endpoint);
            }
            if (type.isAssignableFrom(PollingConsumer.class)) {
                return this.createInjectionPollingConsumer(endpoint);
            }
            if (type.isInterface()) {
                try {
                    return ProxyHelper.createProxy((Endpoint)endpoint, (Class[])new Class[]{type});
                }
                catch (Exception e) {
                    throw new BeanInstantiationException(type, "Could not instantiate proxy of type " + type.getName() + " on endpoint " + endpoint, (Throwable)e);
                }
            }
            throw new IllegalArgumentException("Invalid type: " + type.getName() + " which cannot be injected via @EndpointInject for " + endpoint);
        }
        return null;
    }

    protected PollingConsumer createInjectionPollingConsumer(Endpoint endpoint) {
        try {
            PollingConsumer pollingConsumer = endpoint.createPollingConsumer();
            this.startService((Service)pollingConsumer);
            return pollingConsumer;
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected Producer createInjectionProducer(Endpoint endpoint) {
        try {
            Producer producer = endpoint.createProducer();
            this.startService((Service)producer);
            return producer;
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected Endpoint getEndpointInjection(String uri, String name, String injectionPointName) {
        Endpoint endpoint = null;
        if (ObjectHelper.isNotNullAndNonEmpty((String)uri)) {
            endpoint = this.camelContext.getEndpoint(uri);
        } else {
            if (ObjectHelper.isNullOrBlank((String)name)) {
                name = injectionPointName;
            }
            if ((endpoint = (Endpoint)this.applicationContext.getBean(name)) == null) {
                throw new NoSuchBeanDefinitionException(name);
            }
        }
        return endpoint;
    }
}

