/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.jbi.runtime.impl;

import java.net.URI;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.servicemix.jbi.runtime.impl.InOnlyImpl;
import org.apache.servicemix.jbi.runtime.impl.InOptionalOutImpl;
import org.apache.servicemix.jbi.runtime.impl.InOutImpl;
import org.apache.servicemix.jbi.runtime.impl.MessageExchangeImpl;
import org.apache.servicemix.jbi.runtime.impl.RobustInOnlyImpl;
import org.apache.servicemix.nmr.api.Exchange;
import org.apache.servicemix.nmr.api.Pattern;
import org.apache.servicemix.nmr.core.ExchangeImpl;

public class MessageExchangeFactoryImpl
implements MessageExchangeFactory {
    private QName interfaceName;
    private QName serviceName;
    private QName operationName;
    private ServiceEndpoint endpoint;
    private AtomicBoolean closed;

    public MessageExchangeFactoryImpl(AtomicBoolean closed) {
        this.closed = closed;
    }

    protected void checkNotClosed() throws MessagingException {
        if (this.closed.get()) {
            throw new MessagingException("DeliveryChannel has been closed.");
        }
    }

    public MessageExchange createExchange(URI pattern) throws MessagingException {
        this.checkNotClosed();
        InOnly result = null;
        if (pattern != null) {
            Pattern p = Pattern.fromWsdlUri((String)pattern.toString());
            if (p == Pattern.InOnly) {
                result = this.createInOnlyExchange();
            } else if (p == Pattern.InOut) {
                result = this.createInOutExchange();
            } else if (p == Pattern.InOptionalOut) {
                result = this.createInOptionalOutExchange();
            } else if (p == Pattern.RobustInOnly) {
                result = this.createRobustInOnlyExchange();
            }
        }
        if (result == null) {
            throw new MessagingException("Do not understand pattern: " + pattern);
        }
        return result;
    }

    public InOnly createInOnlyExchange() throws MessagingException {
        this.checkNotClosed();
        InOnlyImpl result = new InOnlyImpl((Exchange)new ExchangeImpl(Pattern.InOnly));
        this.setDefaults(result);
        return result;
    }

    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        this.checkNotClosed();
        RobustInOnlyImpl result = new RobustInOnlyImpl((Exchange)new ExchangeImpl(Pattern.RobustInOnly));
        this.setDefaults(result);
        return result;
    }

    public InOut createInOutExchange() throws MessagingException {
        this.checkNotClosed();
        InOutImpl result = new InOutImpl((Exchange)new ExchangeImpl(Pattern.InOut));
        this.setDefaults(result);
        return result;
    }

    public InOptionalOut createInOptionalOutExchange() throws MessagingException {
        this.checkNotClosed();
        InOptionalOutImpl result = new InOptionalOutImpl((Exchange)new ExchangeImpl(Pattern.InOptionalOut));
        this.setDefaults(result);
        return result;
    }

    public MessageExchange createExchange(QName svcName, QName opName) throws MessagingException {
        this.checkNotClosed();
        InOptionalOutImpl me = new InOptionalOutImpl((Exchange)new ExchangeImpl(Pattern.InOptionalOut));
        this.setDefaults(me);
        me.setService(svcName);
        me.setOperation(opName);
        return me;
    }

    public ServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(ServiceEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public QName getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public QName getOperationName() {
        return this.operationName;
    }

    public void setOperationName(QName operationName) {
        this.operationName = operationName;
    }

    protected void setDefaults(MessageExchangeImpl exchange) {
        exchange.getInternalExchange().setProperty(MessageExchange.class, (Object)exchange);
        exchange.setOperation(this.getOperationName());
        if (this.endpoint != null) {
            exchange.setEndpoint(this.getEndpoint());
        } else {
            exchange.setService(this.serviceName);
            exchange.setInterfaceName(this.interfaceName);
        }
    }
}

