/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.xml;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.digester.BeanPropertySetterRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.digester.RuleSetBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.xml.CalendarBundle;
import org.quartz.xml.JobSchedulingBundle;
import org.quartz.xml.ValidationException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JobSchedulingDataProcessor
extends DefaultHandler {
    public static final String QUARTZ_PUBLIC_ID = "-//Quartz Enterprise Job Scheduler//DTD Job Scheduling Data 1.5//EN";
    public static final String QUARTZ_SYSTEM_ID = "http://www.opensymphony.com/quartz/xml/job_scheduling_data_1_5.dtd";
    public static final String QUARTZ_DTD = "/org/quartz/xml/job_scheduling_data_1_5.dtd";
    public static final String QUARTZ_NS = "http://www.opensymphony.com/quartz/JobSchedulingData";
    public static final String QUARTZ_SCHEMA = "http://www.opensymphony.com/quartz/xml/job_scheduling_data_1_5.xsd";
    public static final String QUARTZ_XSD = "/org/quartz/xml/job_scheduling_data_1_5.xsd";
    public static final String QUARTZ_SYSTEM_ID_DIR_PROP = "quartz.system.id.dir";
    public static final String QUARTZ_XML_FILE_NAME = "quartz_jobs.xml";
    public static final String QUARTZ_SYSTEM_ID_PREFIX = "jar:";
    protected static final String TAG_QUARTZ = "quartz";
    protected static final String TAG_OVERWRITE_EXISTING_JOBS = "overwrite-existing-jobs";
    protected static final String TAG_JOB_LISTENER = "job-listener";
    protected static final String TAG_CALENDAR = "calendar";
    protected static final String TAG_CLASS_NAME = "class-name";
    protected static final String TAG_DESCRIPTION = "description";
    protected static final String TAG_BASE_CALENDAR = "base-calendar";
    protected static final String TAG_MISFIRE_INSTRUCTION = "misfire-instruction";
    protected static final String TAG_CALENDAR_NAME = "calendar-name";
    protected static final String TAG_JOB = "job";
    protected static final String TAG_JOB_DETAIL = "job-detail";
    protected static final String TAG_NAME = "name";
    protected static final String TAG_GROUP = "group";
    protected static final String TAG_JOB_CLASS = "job-class";
    protected static final String TAG_JOB_LISTENER_REF = "job-listener-ref";
    protected static final String TAG_VOLATILITY = "volatility";
    protected static final String TAG_DURABILITY = "durability";
    protected static final String TAG_RECOVER = "recover";
    protected static final String TAG_JOB_DATA_MAP = "job-data-map";
    protected static final String TAG_ENTRY = "entry";
    protected static final String TAG_KEY = "key";
    protected static final String TAG_ALLOWS_TRANSIENT_DATA = "allows-transient-data";
    protected static final String TAG_VALUE = "value";
    protected static final String TAG_TRIGGER = "trigger";
    protected static final String TAG_SIMPLE = "simple";
    protected static final String TAG_CRON = "cron";
    protected static final String TAG_JOB_NAME = "job-name";
    protected static final String TAG_JOB_GROUP = "job-group";
    protected static final String TAG_START_TIME = "start-time";
    protected static final String TAG_END_TIME = "end-time";
    protected static final String TAG_REPEAT_COUNT = "repeat-count";
    protected static final String TAG_REPEAT_INTERVAL = "repeat-interval";
    protected static final String TAG_CRON_EXPRESSION = "cron-expression";
    protected static final String TAG_TIME_ZONE = "time-zone";
    protected static final String XSD_DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss";
    protected static final String DTD_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss a";
    protected Map scheduledJobs = new HashMap();
    protected List jobsToSchedule = new LinkedList();
    protected List calsToSchedule = new LinkedList();
    protected List listenersToSchedule = new LinkedList();
    protected Collection validationExceptions = new ArrayList();
    protected Digester digester;
    private boolean overWriteExistingJobs = true;
    private ThreadLocal schedLocal = new ThreadLocal();
    static /* synthetic */ Class class$org$quartz$xml$JobSchedulingBundle;
    static /* synthetic */ Class class$org$quartz$JobDetail;
    static /* synthetic */ Class class$org$quartz$JobDataMap;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$quartz$SimpleTrigger;
    static /* synthetic */ Class class$org$quartz$CronTrigger;
    static /* synthetic */ Class class$java$util$TimeZone;
    static /* synthetic */ Class class$org$quartz$xml$JobSchedulingDataProcessor;
    static /* synthetic */ Class class$org$quartz$xml$CalendarBundle;
    static /* synthetic */ Class class$org$quartz$Trigger;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;

    public JobSchedulingDataProcessor() {
        this(true, true, true);
    }

    public JobSchedulingDataProcessor(boolean useContextClassLoader, boolean validating, boolean validatingSchema) {
        this.initDigester(useContextClassLoader, validating, validatingSchema);
    }

    protected void initDigester(boolean useContextClassLoader, boolean validating, boolean validatingSchema) {
        this.digester = new Digester();
        this.digester.setNamespaceAware(true);
        this.digester.setUseContextClassLoader(useContextClassLoader);
        this.digester.setValidating(validating);
        this.initSchemaValidation(validatingSchema);
        this.digester.setEntityResolver((EntityResolver)this);
        this.digester.setErrorHandler((ErrorHandler)this);
        if (this.addCustomDigesterRules(this.digester)) {
            this.addDefaultDigesterRules(this.digester);
        }
    }

    protected void addDefaultDigesterRules(Digester digester) {
        digester.addSetProperties(TAG_QUARTZ, TAG_OVERWRITE_EXISTING_JOBS, "overWriteExistingJobs");
        digester.addObjectCreate("quartz/job-listener", "jobListener", TAG_CLASS_NAME);
        digester.addCallMethod("quartz/job-listener", "setName", 1);
        digester.addCallParam("quartz/job-listener", 0, TAG_NAME);
        digester.addSetNext("quartz/job-listener", "addListenerToSchedule");
        digester.addRuleSet((RuleSet)new CalendarRuleSet("quartz/calendar", "addCalendarToSchedule"));
        digester.addRuleSet((RuleSet)new CalendarRuleSet("*/base-calendar", "setBaseCalendar"));
        digester.addObjectCreate("quartz/job", class$org$quartz$xml$JobSchedulingBundle == null ? (class$org$quartz$xml$JobSchedulingBundle = JobSchedulingDataProcessor.class$("org.quartz.xml.JobSchedulingBundle")) : class$org$quartz$xml$JobSchedulingBundle);
        digester.addObjectCreate("quartz/job/job-detail", class$org$quartz$JobDetail == null ? (class$org$quartz$JobDetail = JobSchedulingDataProcessor.class$("org.quartz.JobDetail")) : class$org$quartz$JobDetail);
        digester.addBeanPropertySetter("quartz/job/job-detail/name", TAG_NAME);
        digester.addBeanPropertySetter("quartz/job/job-detail/group", TAG_GROUP);
        digester.addBeanPropertySetter("quartz/job/job-detail/description", TAG_DESCRIPTION);
        digester.addBeanPropertySetter("quartz/job/job-detail/job-class", "jobClass");
        digester.addCallMethod("quartz/job/job-detail/job-listener-ref", "addJobListener", 0);
        digester.addBeanPropertySetter("quartz/job/job-detail/volatility", TAG_VOLATILITY);
        digester.addBeanPropertySetter("quartz/job/job-detail/durability", TAG_DURABILITY);
        digester.addBeanPropertySetter("quartz/job/job-detail/recover", "requestsRecovery");
        digester.addObjectCreate("quartz/job/job-detail/job-data-map", class$org$quartz$JobDataMap == null ? (class$org$quartz$JobDataMap = JobSchedulingDataProcessor.class$("org.quartz.JobDataMap")) : class$org$quartz$JobDataMap);
        digester.addSetProperties("quartz/job/job-detail/job-data-map", TAG_ALLOWS_TRANSIENT_DATA, "allowsTransientData");
        digester.addCallMethod("quartz/job/job-detail/job-data-map/entry", "put", 2, new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = JobSchedulingDataProcessor.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Object == null ? (class$java$lang$Object = JobSchedulingDataProcessor.class$("java.lang.Object")) : class$java$lang$Object});
        digester.addCallParam("quartz/job/job-detail/job-data-map/entry/key", 0);
        digester.addCallParam("quartz/job/job-detail/job-data-map/entry/value", 1);
        digester.addSetNext("quartz/job/job-detail/job-data-map", "setJobDataMap");
        digester.addSetNext("quartz/job/job-detail", "setJobDetail");
        digester.addRuleSet((RuleSet)new TriggerRuleSet("quartz/job/trigger/simple", class$org$quartz$SimpleTrigger == null ? (class$org$quartz$SimpleTrigger = JobSchedulingDataProcessor.class$("org.quartz.SimpleTrigger")) : class$org$quartz$SimpleTrigger));
        digester.addBeanPropertySetter("quartz/job/trigger/simple/repeat-count", "repeatCount");
        digester.addBeanPropertySetter("quartz/job/trigger/simple/repeat-interval", "repeatInterval");
        digester.addSetNext("quartz/job/trigger/simple", "addTrigger");
        digester.addRuleSet((RuleSet)new TriggerRuleSet("quartz/job/trigger/cron", class$org$quartz$CronTrigger == null ? (class$org$quartz$CronTrigger = JobSchedulingDataProcessor.class$("org.quartz.CronTrigger")) : class$org$quartz$CronTrigger));
        digester.addBeanPropertySetter("quartz/job/trigger/cron/cron-expression", "cronExpression");
        digester.addRule("quartz/job/trigger/cron/time-zone", (Rule)new SimpleConverterRule("timeZone", new TimeZoneConverter(), class$java$util$TimeZone == null ? (class$java$util$TimeZone = JobSchedulingDataProcessor.class$("java.util.TimeZone")) : class$java$util$TimeZone));
        digester.addSetNext("quartz/job/trigger/cron", "addTrigger");
        digester.addSetNext("quartz/job", "addJobToSchedule");
    }

    protected boolean addCustomDigesterRules(Digester digester) {
        return true;
    }

    protected void initSchemaValidation(boolean validatingSchema) {
        if (validatingSchema) {
            String schemaUri = null;
            URL url = this.getClass().getResource(QUARTZ_XSD);
            schemaUri = url != null ? url.toExternalForm() : QUARTZ_SCHEMA;
            this.digester.setSchema(schemaUri);
        }
    }

    protected static Log getLog() {
        return LogFactory.getLog((Class)(class$org$quartz$xml$JobSchedulingDataProcessor == null ? (class$org$quartz$xml$JobSchedulingDataProcessor = JobSchedulingDataProcessor.class$("org.quartz.xml.JobSchedulingDataProcessor")) : class$org$quartz$xml$JobSchedulingDataProcessor));
    }

    public boolean getUseContextClassLoader() {
        return this.digester.getUseContextClassLoader();
    }

    public void setUseContextClassLoader(boolean useContextClassLoader) {
        this.digester.setUseContextClassLoader(useContextClassLoader);
    }

    public boolean getOverWriteExistingJobs() {
        return this.overWriteExistingJobs;
    }

    public void setOverWriteExistingJobs(boolean overWriteExistingJobs) {
        this.overWriteExistingJobs = overWriteExistingJobs;
    }

    public void processFile() throws Exception {
        this.processFile(QUARTZ_XML_FILE_NAME);
    }

    public void processFile(String fileName) throws Exception {
        this.processFile(fileName, fileName);
    }

    public void processFile(String fileName, String systemId) throws ValidationException, ParserConfigurationException, SAXException, IOException, SchedulerException, ClassNotFoundException, ParseException {
        this.clearValidationExceptions();
        this.scheduledJobs.clear();
        this.jobsToSchedule.clear();
        this.calsToSchedule.clear();
        JobSchedulingDataProcessor.getLog().info((Object)("Parsing XML file: " + fileName + " with systemId: " + systemId + " validating: " + this.digester.getValidating() + " validating schema: " + this.digester.getSchema()));
        InputSource is = new InputSource(this.getInputStream(fileName));
        is.setSystemId(systemId);
        this.digester.push((Object)this);
        this.digester.parse(is);
        this.maybeThrowValidationException();
    }

    public void processStream(InputStream stream, String systemId) throws ValidationException, ParserConfigurationException, SAXException, IOException, SchedulerException, ClassNotFoundException, ParseException {
        this.clearValidationExceptions();
        this.scheduledJobs.clear();
        this.jobsToSchedule.clear();
        this.calsToSchedule.clear();
        JobSchedulingDataProcessor.getLog().info((Object)("Parsing XML from stream with systemId: " + systemId + " validating: " + this.digester.getValidating() + " validating schema: " + this.digester.getSchema()));
        InputSource is = new InputSource(stream);
        is.setSystemId(systemId);
        this.digester.push((Object)this);
        this.digester.parse(is);
        this.maybeThrowValidationException();
    }

    public void processFileAndScheduleJobs(Scheduler sched, boolean overWriteExistingJobs) throws SchedulerException, Exception {
        this.processFileAndScheduleJobs(QUARTZ_XML_FILE_NAME, sched, overWriteExistingJobs);
    }

    public void processFileAndScheduleJobs(String fileName, Scheduler sched, boolean overWriteExistingJobs) throws Exception {
        this.processFileAndScheduleJobs(fileName, fileName, sched, overWriteExistingJobs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFileAndScheduleJobs(String fileName, String systemId, Scheduler sched, boolean overWriteExistingJobs) throws Exception {
        this.schedLocal.set(sched);
        try {
            this.processFile(fileName, systemId);
            this.scheduleJobs(this.getScheduledJobs(), sched, overWriteExistingJobs);
        }
        finally {
            this.schedLocal.set(null);
        }
    }

    public void scheduleJobs(Map jobBundles, Scheduler sched, boolean overWriteExistingJobs) throws Exception {
        Object bndle;
        JobSchedulingDataProcessor.getLog().info((Object)("Scheduling " + this.jobsToSchedule.size() + " parsed jobs."));
        Iterator itr = this.calsToSchedule.iterator();
        while (itr.hasNext()) {
            bndle = (CalendarBundle)itr.next();
            this.addCalendar(sched, (CalendarBundle)bndle);
        }
        itr = this.jobsToSchedule.iterator();
        while (itr.hasNext()) {
            bndle = (JobSchedulingBundle)itr.next();
            this.scheduleJob((JobSchedulingBundle)bndle, sched, overWriteExistingJobs);
        }
        itr = this.listenersToSchedule.iterator();
        while (itr.hasNext()) {
            JobListener listener = (JobListener)itr.next();
            JobSchedulingDataProcessor.getLog().info((Object)("adding listener " + listener.getName() + " of class " + listener.getClass().getName()));
            sched.addJobListener(listener);
        }
        JobSchedulingDataProcessor.getLog().info((Object)(jobBundles.size() + " scheduled jobs."));
    }

    public Map getScheduledJobs() {
        return Collections.unmodifiableMap(this.scheduledJobs);
    }

    public JobSchedulingBundle getScheduledJob(String name) {
        return (JobSchedulingBundle)this.getScheduledJobs().get(name);
    }

    protected InputStream getInputStream(String fileName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(fileName);
        return is;
    }

    public void scheduleJob(JobSchedulingBundle job) throws SchedulerException {
        this.scheduleJob(job, (Scheduler)this.schedLocal.get(), this.getOverWriteExistingJobs());
    }

    public void addJobToSchedule(JobSchedulingBundle job) {
        this.jobsToSchedule.add(job);
    }

    public void addCalendarToSchedule(CalendarBundle cal) {
        this.calsToSchedule.add(cal);
    }

    public void addListenerToSchedule(JobListener listener) {
        this.listenersToSchedule.add(listener);
    }

    public void scheduleJob(JobSchedulingBundle job, Scheduler sched, boolean localOverWriteExistingJobs) throws SchedulerException {
        if (job != null && job.isValid()) {
            JobDetail detail = job.getJobDetail();
            JobDetail dupeJ = sched.getJobDetail(detail.getName(), detail.getGroup());
            if (dupeJ != null && !localOverWriteExistingJobs) {
                JobSchedulingDataProcessor.getLog().info((Object)("Not overwriting existing job: " + dupeJ.getFullName()));
                return;
            }
            if (dupeJ != null) {
                JobSchedulingDataProcessor.getLog().info((Object)("Replacing job: " + detail.getFullName()));
            } else {
                JobSchedulingDataProcessor.getLog().info((Object)("Adding job: " + detail.getFullName()));
            }
            if (job.getTriggers().size() == 0 && !job.getJobDetail().isDurable()) {
                throw new SchedulerException("A Job defined without any triggers must be durable");
            }
            sched.addJob(detail, true);
            Iterator iter = job.getTriggers().iterator();
            while (iter.hasNext()) {
                Trigger trigger = (Trigger)iter.next();
                Trigger dupeT = sched.getTrigger(trigger.getName(), trigger.getGroup());
                trigger.setJobName(detail.getName());
                trigger.setJobGroup(detail.getGroup());
                if (trigger.getStartTime() == null) {
                    trigger.setStartTime(new Date());
                }
                if (dupeT != null) {
                    JobSchedulingDataProcessor.getLog().debug((Object)("Rescheduling job: " + detail.getFullName() + " with updated trigger: " + trigger.getFullName()));
                    if (!dupeT.getJobGroup().equals(trigger.getJobGroup()) || !dupeT.getJobName().equals(trigger.getJobName())) {
                        JobSchedulingDataProcessor.getLog().warn((Object)"Possibly duplicately named triggers in jobs xml file!");
                    }
                    sched.rescheduleJob(trigger.getName(), trigger.getGroup(), trigger);
                    continue;
                }
                JobSchedulingDataProcessor.getLog().debug((Object)("Scheduling job: " + detail.getFullName() + " with trigger: " + trigger.getFullName()));
                sched.scheduleJob(trigger);
            }
            this.addScheduledJob(job);
        }
    }

    protected void addScheduledJob(JobSchedulingBundle job) {
        this.scheduledJobs.put(job.getFullName(), job);
    }

    public void addCalendar(Scheduler sched, CalendarBundle calendarBundle) throws SchedulerException {
        sched.addCalendar(calendarBundle.getCalendarName(), calendarBundle.getCalendar(), calendarBundle.getReplace(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputSource resolveEntity(String publicId, String systemId) {
        InputSource inputSource = null;
        InputStream is = null;
        URL url = null;
        try {
            block17: {
                try {
                    if (publicId == null) {
                        if (systemId != null) {
                            if (QUARTZ_SCHEMA.equals(systemId)) {
                                is = this.getClass().getResourceAsStream(QUARTZ_DTD);
                            } else {
                                is = this.getInputStream(systemId);
                                if (is == null) {
                                    int start = systemId.indexOf(QUARTZ_SYSTEM_ID_PREFIX);
                                    if (start > -1) {
                                        String fileName = systemId.substring(QUARTZ_SYSTEM_ID_PREFIX.length());
                                        is = this.getInputStream(fileName);
                                    } else {
                                        if (systemId.indexOf(58) == -1) {
                                            File file = new File(systemId);
                                            url = file.toURL();
                                        } else {
                                            url = new URL(systemId);
                                        }
                                        is = url.openStream();
                                    }
                                }
                            }
                        }
                        break block17;
                    }
                    if (QUARTZ_PUBLIC_ID.equals(publicId)) {
                        is = this.getClass().getResourceAsStream(QUARTZ_DTD);
                        break block17;
                    }
                    url = new URL(systemId);
                    is = url.openStream();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var9_11 = null;
                    if (is != null) {
                        inputSource = new InputSource(is);
                        inputSource.setPublicId(publicId);
                        inputSource.setSystemId(systemId);
                    }
                }
            }
            Object var9_10 = null;
            if (is != null) {
                inputSource = new InputSource(is);
                inputSource.setPublicId(publicId);
                inputSource.setSystemId(systemId);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (is != null) {
                inputSource = new InputSource(is);
                inputSource.setPublicId(publicId);
                inputSource.setSystemId(systemId);
            }
            throw throwable;
        }
        return inputSource;
    }

    public void warning(SAXParseException e) throws SAXException {
        this.addValidationException(e);
    }

    public void error(SAXParseException e) throws SAXException {
        this.addValidationException(e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.addValidationException(e);
    }

    protected void addValidationException(SAXException e) {
        this.validationExceptions.add(e);
    }

    protected void clearValidationExceptions() {
        this.validationExceptions.clear();
    }

    protected void maybeThrowValidationException() throws ValidationException {
        if (this.validationExceptions.size() > 0) {
            throw new ValidationException(this.validationExceptions);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final class TimeZoneConverter
    implements Converter {
        public Object convert(Class type, Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof TimeZone) {
                return value;
            }
            try {
                if ((class$java$lang$String == null ? (class$java$lang$String = JobSchedulingDataProcessor.class$("java.lang.String")) : class$java$lang$String).equals(value.getClass())) {
                    return TimeZone.getTimeZone((String)value);
                }
                return value.toString();
            }
            catch (Exception e) {
                throw new ConversionException((Throwable)e);
            }
        }
    }

    public final class DateConverter
    implements Converter {
        private Object defaultValue = null;
        private boolean useDefault = true;
        private DateFormat[] dateFormats;

        public DateConverter() {
            this.defaultValue = null;
            this.useDefault = false;
        }

        public DateConverter(Object defaultValue) {
            this.defaultValue = defaultValue;
            this.useDefault = true;
        }

        public DateConverter(String[] formats) {
            this();
            int len = formats.length;
            this.dateFormats = new DateFormat[len];
            for (int i = 0; i < len; ++i) {
                this.dateFormats[i] = new SimpleDateFormat(formats[i]);
            }
        }

        public Object convert(Class type, Object value) {
            if (value == null) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                return null;
            }
            if ((class$java$lang$String == null ? (class$java$lang$String = JobSchedulingDataProcessor.class$("java.lang.String")) : class$java$lang$String).equals(type)) {
                if (value instanceof Date && this.dateFormats != null) {
                    return this.dateFormats[0].format((Date)value);
                }
                return value.toString();
            }
            if (value instanceof Date) {
                return value;
            }
            try {
                if ((class$java$util$Date == null ? (class$java$util$Date = JobSchedulingDataProcessor.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(type) && this.dateFormats != null) {
                    return this.parseDate(value);
                }
                return value.toString();
            }
            catch (Exception e) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException((Throwable)e);
            }
        }

        protected Date parseDate(Object value) throws ParseException {
            Date date = null;
            int len = this.dateFormats.length;
            for (int i = 0; i < len; ++i) {
                try {
                    date = this.dateFormats[i].parse(value.toString());
                    break;
                }
                catch (ParseException e) {
                    if (i != len - 1) continue;
                    throw e;
                }
            }
            return date;
        }
    }

    public class MisfireInstructionRule
    extends BeanPropertySetterRule {
        public MisfireInstructionRule(String propertyName) {
            this.propertyName = propertyName;
        }

        public void body(String namespace, String name, String text) throws Exception {
            super.body(namespace, name, text);
            this.bodyText = this.getConstantValue(this.bodyText);
        }

        private String getConstantValue(String constantName) {
            String value = "0";
            Object top = this.digester.peek();
            if (top != null) {
                Class<?> clazz = top.getClass();
                try {
                    Field field = clazz.getField(constantName);
                    Object fieldValue = field.get(top);
                    if (fieldValue != null) {
                        value = fieldValue.toString();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return value;
        }
    }

    public class SimpleConverterRule
    extends BeanPropertySetterRule {
        private Converter converter;
        private Class clazz;

        public SimpleConverterRule(String propertyName, Converter converter, Class clazz) {
            this.propertyName = propertyName;
            if (converter == null) {
                throw new IllegalArgumentException("Converter must not be null");
            }
            this.converter = converter;
            if (clazz == null) {
                throw new IllegalArgumentException("Class must not be null");
            }
            this.clazz = clazz;
        }

        public void end(String namespace, String name) throws Exception {
            PropertyDescriptor desc;
            String property = this.propertyName;
            if (property == null) {
                property = name;
            }
            Object top = this.digester.peek();
            if (this.getDigester().getLogger().isDebugEnabled()) {
                this.getDigester().getLogger().debug((Object)("[BeanPropertySetterRule]{" + this.getDigester().getMatch() + "} Set " + top.getClass().getName() + " property " + property + " with text " + this.bodyText));
            }
            if (top instanceof DynaBean ? (desc = ((DynaBean)top).getDynaClass().getDynaProperty(property)) == null : (desc = PropertyUtils.getPropertyDescriptor((Object)top, (String)property)) == null) {
                throw new NoSuchMethodException("Bean has no property named " + property);
            }
            Object value = this.converter.convert(this.clazz, (Object)this.bodyText);
            PropertyUtils.setProperty((Object)top, (String)property, (Object)value);
        }
    }

    public class TriggerRuleSet
    extends RuleSetBase {
        protected String prefix;
        protected Class clazz;

        public TriggerRuleSet(String prefix, Class clazz) {
            this.prefix = prefix;
            if (!(class$org$quartz$Trigger == null ? (class$org$quartz$Trigger = JobSchedulingDataProcessor.class$("org.quartz.Trigger")) : class$org$quartz$Trigger).isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class must be an instance of Trigger");
            }
            this.clazz = clazz;
        }

        public void addRuleInstances(Digester digester) {
            digester.addObjectCreate(this.prefix, this.clazz);
            digester.addBeanPropertySetter(this.prefix + "/" + JobSchedulingDataProcessor.TAG_NAME, JobSchedulingDataProcessor.TAG_NAME);
            digester.addBeanPropertySetter(this.prefix + "/" + JobSchedulingDataProcessor.TAG_GROUP, JobSchedulingDataProcessor.TAG_GROUP);
            digester.addBeanPropertySetter(this.prefix + "/" + JobSchedulingDataProcessor.TAG_DESCRIPTION, JobSchedulingDataProcessor.TAG_DESCRIPTION);
            digester.addBeanPropertySetter(this.prefix + "/" + JobSchedulingDataProcessor.TAG_VOLATILITY, JobSchedulingDataProcessor.TAG_VOLATILITY);
            digester.addRule(this.prefix + "/" + JobSchedulingDataProcessor.TAG_MISFIRE_INSTRUCTION, (Rule)new MisfireInstructionRule("misfireInstruction"));
            digester.addBeanPropertySetter(this.prefix + "/" + JobSchedulingDataProcessor.TAG_CALENDAR_NAME, "calendarName");
            digester.addBeanPropertySetter(this.prefix + "/" + JobSchedulingDataProcessor.TAG_JOB_NAME, "jobName");
            digester.addBeanPropertySetter(this.prefix + "/" + JobSchedulingDataProcessor.TAG_JOB_GROUP, "jobGroup");
            DateConverter converter = new DateConverter(new String[]{JobSchedulingDataProcessor.XSD_DATE_FORMAT, JobSchedulingDataProcessor.DTD_DATE_FORMAT});
            digester.addRule(this.prefix + "/" + JobSchedulingDataProcessor.TAG_START_TIME, (Rule)new SimpleConverterRule("startTime", converter, class$java$util$Date == null ? (class$java$util$Date = JobSchedulingDataProcessor.class$("java.util.Date")) : class$java$util$Date));
            digester.addRule(this.prefix + "/" + JobSchedulingDataProcessor.TAG_END_TIME, (Rule)new SimpleConverterRule("endTime", converter, class$java$util$Date == null ? (class$java$util$Date = JobSchedulingDataProcessor.class$("java.util.Date")) : class$java$util$Date));
        }
    }

    public class CalendarRuleSet
    extends RuleSetBase {
        protected String prefix;
        protected String setNextMethodName;

        public CalendarRuleSet(String prefix, String setNextMethodName) {
            this.prefix = prefix;
            this.setNextMethodName = setNextMethodName;
        }

        public void addRuleInstances(Digester digester) {
            digester.addObjectCreate(this.prefix, class$org$quartz$xml$CalendarBundle == null ? (class$org$quartz$xml$CalendarBundle = JobSchedulingDataProcessor.class$("org.quartz.xml.CalendarBundle")) : class$org$quartz$xml$CalendarBundle);
            digester.addSetProperties(this.prefix, JobSchedulingDataProcessor.TAG_CLASS_NAME, "className");
            digester.addBeanPropertySetter(this.prefix + "/" + JobSchedulingDataProcessor.TAG_NAME, "calendarName");
            digester.addBeanPropertySetter(this.prefix + "/" + JobSchedulingDataProcessor.TAG_DESCRIPTION, JobSchedulingDataProcessor.TAG_DESCRIPTION);
            digester.addSetNext(this.prefix, this.setNextMethodName);
        }
    }
}

