/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.saxon;

import java.io.ByteArrayOutputStream;
import java.io.StringWriter;
import java.util.Map;
import javax.jbi.management.DeploymentException;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.servicemix.common.util.MessageUtil;
import org.apache.servicemix.jbi.jaxp.BytesSource;
import org.apache.servicemix.jbi.jaxp.StringSource;
import org.apache.servicemix.saxon.SaxonEndpoint;
import org.apache.servicemix.saxon.support.ExchangeTarget;
import org.apache.servicemix.store.Store;
import org.apache.servicemix.store.StoreFactory;
import org.apache.servicemix.store.memory.MemoryStoreFactory;
import org.springframework.core.io.Resource;

public class XsltProxyEndpoint
extends SaxonEndpoint {
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int FAULT = 2;
    private TransformerFactory transformerFactory;
    private Resource outResource;
    private Resource faultResource;
    private Source[] xsltSource = new Source[3];
    private Templates[] templates = new Templates[3];
    private boolean useDomSourceForXslt = true;
    private Boolean useDomSourceForContent;
    private ExchangeTarget target;
    protected Store store;
    protected StoreFactory storeFactory;
    private String correlation;

    public TransformerFactory getTransformerFactory() {
        if (this.transformerFactory == null) {
            this.transformerFactory = this.createTransformerFactory();
        }
        return this.transformerFactory;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    public Resource getOutResource() {
        return this.outResource;
    }

    public void setOutResource(Resource outResource) {
        this.outResource = outResource;
    }

    public Resource getFaultResource() {
        return this.faultResource;
    }

    public void setFaultResource(Resource faultResource) {
        this.faultResource = faultResource;
    }

    public boolean isUseDomSourceForXslt() {
        return this.useDomSourceForXslt;
    }

    public void setUseDomSourceForXslt(boolean useDomSourceForXslt) {
        this.useDomSourceForXslt = useDomSourceForXslt;
    }

    public Boolean getUseDomSourceForContent() {
        return this.useDomSourceForContent;
    }

    public void setUseDomSourceForContent(Boolean useDomSourceForContent) {
        this.useDomSourceForContent = useDomSourceForContent;
    }

    public ExchangeTarget getTarget() {
        return this.target;
    }

    public void setTarget(ExchangeTarget target) {
        this.target = target;
    }

    public Store getStore() {
        return this.store;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public StoreFactory getStoreFactory() {
        return this.storeFactory;
    }

    public void setStoreFactory(StoreFactory storeFactory) {
        this.storeFactory = storeFactory;
    }

    public void validate() throws DeploymentException {
        if (this.target == null) {
            throw new DeploymentException("target must be specified");
        }
        this.correlation = "XsltProxy.Correlation." + this.getService() + "." + this.getEndpoint();
    }

    public void start() throws Exception {
        super.start();
        if (this.store == null) {
            if (this.storeFactory == null) {
                this.storeFactory = new MemoryStoreFactory();
            }
            this.store = this.storeFactory.open(this.getService().toString() + this.getEndpoint());
        }
    }

    public void process(MessageExchange exchange) throws Exception {
        if (exchange.getRole() == MessageExchange.Role.PROVIDER && exchange.getProperty(this.correlation) == null) {
            MessageExchange tme = this.getExchangeFactory().createExchange(exchange.getPattern());
            if (this.store.hasFeature("Clustered")) {
                exchange.setProperty("org.apache.servicemix.provider.stateless", (Object)Boolean.TRUE);
                tme.setProperty("org.apache.servicemix.consumer.stateless", (Object)Boolean.TRUE);
            }
            this.target.configureTarget(tme, this.getContext());
            exchange.setProperty(this.correlation, (Object)tme.getExchangeId());
            tme.setProperty(this.correlation, (Object)exchange.getExchangeId());
            this.store.store(exchange.getExchangeId(), (Object)exchange);
            tme.setMessage(tme.createMessage(), "in");
            this.transform(exchange, exchange.getMessage("in"), tme, tme.getMessage("in"), 0);
            if (tme.getOperation() == null) {
                tme.setOperation(exchange.getOperation());
            }
            this.send(tme);
        } else {
            String id = (String)exchange.getProperty(this.correlation);
            if (id == null) {
                if (exchange.getRole() == MessageExchange.Role.CONSUMER && exchange.getStatus() != ExchangeStatus.ACTIVE) {
                    return;
                }
                throw new IllegalStateException(this.correlation + " property not found");
            }
            MessageExchange org = (MessageExchange)this.store.load(id);
            if (org == null) {
                throw new IllegalStateException("Could not load original exchange with id " + id);
            }
            if (exchange.getStatus() == ExchangeStatus.DONE) {
                this.done(org);
            } else if (exchange.getStatus() == ExchangeStatus.ERROR) {
                this.fail(org, exchange.getError());
            } else if (exchange.getFault() != null) {
                this.store.store(exchange.getExchangeId(), (Object)exchange);
                org.setFault(org.createFault());
                this.transform(exchange, (NormalizedMessage)exchange.getFault(), org, (NormalizedMessage)org.getFault(), 2);
                this.send(org);
            } else if (exchange.getMessage("out") != null) {
                this.store.store(exchange.getExchangeId(), (Object)exchange);
                org.setMessage(org.createMessage(), "out");
                this.transform(exchange, exchange.getMessage("out"), org, org.getMessage("out"), 1);
                this.send(org);
            } else {
                throw new IllegalStateException("Exchange status is " + ExchangeStatus.ACTIVE + " but has no Out nor Fault message");
            }
        }
    }

    protected void transform(MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void transform(MessageExchange inExchange, NormalizedMessage inMessage, MessageExchange outExchange, NormalizedMessage outMessage, int type) throws Exception {
        Transformer transformer = this.createTransformer(inExchange, inMessage, type);
        if (transformer != null) {
            this.configureTransformer(transformer, inExchange, inMessage, outExchange, outMessage);
            this.transformContent(transformer, inExchange, inMessage, outMessage);
            this.copyPropertiesAndAttachments(inMessage, outMessage);
        } else {
            MessageUtil.transfer((NormalizedMessage)inMessage, (NormalizedMessage)outMessage);
        }
    }

    protected void transformContent(Transformer transformer, MessageExchange exchange, NormalizedMessage in, NormalizedMessage out) throws Exception {
        Source src = in.getContent();
        if (this.useDomSourceForContent != null && this.useDomSourceForContent.booleanValue()) {
            src = new DOMSource(this.getSourceTransformer().toDOMDocument(src));
        } else if (this.useDomSourceForContent != null && !this.useDomSourceForContent.booleanValue()) {
            src = this.getSourceTransformer().toStreamSource(src);
        } else if (src instanceof DOMSource) {
            src = new DOMSource(this.getSourceTransformer().toDOMDocument(src));
        }
        if ("bytes".equalsIgnoreCase(this.getResult())) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(buffer);
            transformer.transform(src, result);
            out.setContent((Source)new BytesSource(buffer.toByteArray()));
        } else if ("string".equalsIgnoreCase(this.getResult())) {
            StringWriter buffer = new StringWriter();
            StreamResult result = new StreamResult(buffer);
            transformer.transform(src, result);
            out.setContent((Source)new StringSource(buffer.toString()));
        } else {
            DOMResult result = new DOMResult();
            transformer.transform(src, result);
            out.setContent((Source)new DOMSource(result.getNode()));
        }
    }

    protected Source getXsltSource(int type) throws Exception {
        if (this.xsltSource[type] == null) {
            this.xsltSource[type] = this.createXsltSource(this.getResource(type));
        }
        return this.xsltSource[type];
    }

    protected Resource getResource(int type) {
        switch (type) {
            case 0: {
                return this.getResource();
            }
            case 1: {
                return this.getOutResource();
            }
            case 2: {
                return this.getFaultResource();
            }
        }
        throw new IllegalStateException();
    }

    protected Source createXsltSource(Resource res) throws Exception {
        String url = null;
        try {
            url = res.getURL().toURI().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.useDomSourceForXslt) {
            return new DOMSource(this.parse(res), url);
        }
        return new StreamSource(res.getInputStream(), url);
    }

    public synchronized Templates getTemplates(int type) throws Exception {
        if (this.templates[type] == null) {
            this.templates[type] = this.createTemplates(type);
        }
        return this.templates[type];
    }

    protected Templates createTemplates(int type) throws Exception {
        Source source = this.getXsltSource(type);
        return this.getTransformerFactory().newTemplates(source);
    }

    protected Transformer createTransformer(MessageExchange exchange, NormalizedMessage msg, int type) throws Exception {
        if (this.getExpression() != null) {
            Resource r = this.getDynamicResource(exchange, msg);
            if (r == null) {
                return this.getTransformerFactory().newTransformer();
            }
            Source source = this.createXsltSource(r);
            return this.getTransformerFactory().newTransformer(source);
        }
        if (this.getResource(type) != null) {
            return this.getTemplates(type).newTransformer();
        }
        return null;
    }

    protected TransformerFactory createTransformerFactory() {
        if (this.getConfiguration() != null) {
            return new TransformerFactoryImpl(this.getConfiguration());
        }
        return new TransformerFactoryImpl();
    }

    protected void configureTransformer(Transformer transformer, MessageExchange inExchange, NormalizedMessage inMessage, MessageExchange outExchange, NormalizedMessage outMessage) {
        Object value;
        for (String name : inExchange.getPropertyNames()) {
            value = inExchange.getProperty(name);
            transformer.setParameter(name, value);
        }
        for (String name : inMessage.getPropertyNames()) {
            value = inMessage.getProperty(name);
            transformer.setParameter(name, value);
        }
        Map parameters = this.getParameters();
        if (parameters != null) {
            for (String name : parameters.keySet()) {
                Object value2 = parameters.get(name);
                transformer.setParameter(name, value2);
            }
        }
        transformer.setParameter("inExchange", inExchange);
        transformer.setParameter("inMessage", inMessage);
        transformer.setParameter("outExchange", outExchange);
        transformer.setParameter("outMessage", outMessage);
        transformer.setParameter("component", (Object)this);
    }
}

