/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.kernel.gshell.activemq;

import java.io.File;
import org.apache.geronimo.gshell.clp.Option;
import org.apache.geronimo.gshell.command.annotation.CommandComponent;
import org.apache.geronimo.gshell.support.OsgiCommandSupport;

@CommandComponent(id="activemq:destroy-broker", description="Destroys a broker instance.")
public class DestroyBrokerCommand
extends OsgiCommandSupport {
    @Option(name="-n", aliases={"--name"}, description="The name of the broker (defaults to localhost).")
    private String name = "localhost";

    protected Object doExecute() throws Exception {
        try {
            String name = this.getName();
            File base = new File(System.getProperty("servicemix.base"));
            File deploy = new File(base, "deploy");
            File configFile = new File(deploy, name + "-broker.xml");
            configFile.delete();
            this.io.out.println("");
            this.io.out.println("Default ActiveMQ Broker (" + name + ") configuration file created at: " + configFile.getPath() + " removed.");
            this.io.out.println("");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return 0;
    }

    public String getName() {
        if (this.name == null) {
            File base = new File(System.getProperty("servicemix.base"));
            this.name = base.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

