/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.util.SecureAction;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.service.url.URLStreamHandlerSetter;

public class URLHandlersStreamHandlerProxy
extends URLStreamHandler
implements URLStreamHandlerSetter,
InvocationHandler {
    private final Map m_trackerMap = new HashMap();
    private final String m_protocol;
    private final Object m_service;
    private final SecureAction m_action;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerService;
    static /* synthetic */ Class class$org$apache$felix$framework$URLHandlersServiceTracker;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$osgi$service$url$URLStreamHandlerSetter;

    public URLHandlersStreamHandlerProxy(String protocol, SecureAction action) {
        this.m_protocol = protocol;
        this.m_service = null;
        this.m_action = action;
    }

    private URLHandlersStreamHandlerProxy(Object service, SecureAction action) {
        this.m_protocol = null;
        this.m_service = service;
        this.m_action = action;
    }

    protected synchronized boolean equals(URL url1, URL url2) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        return svc.equals(url1, url2);
    }

    protected synchronized int getDefaultPort() {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Stream handler unavailable.");
        }
        return svc.getDefaultPort();
    }

    protected synchronized InetAddress getHostAddress(URL url) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        return svc.getHostAddress(url);
    }

    protected synchronized int hashCode(URL url) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        return svc.hashCode(url);
    }

    protected synchronized boolean hostsEqual(URL url1, URL url2) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        return svc.hostsEqual(url1, url2);
    }

    protected synchronized URLConnection openConnection(URL url) throws IOException {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new MalformedURLException("Unknown protocol: " + url.toString());
        }
        return svc.openConnection(url);
    }

    protected synchronized void parseURL(URL url, String spec, int start, int limit) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        svc.parseURL(this, url, spec, start, limit);
    }

    protected synchronized boolean sameFile(URL url1, URL url2) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url1.getProtocol());
        }
        return svc.sameFile(url1, url2);
    }

    public void setURL(URL url, String protocol, String host, int port, String authority, String userInfo, String path, String query, String ref) {
        super.setURL(url, protocol, host, port, authority, userInfo, path, query, ref);
    }

    public void setURL(URL url, String protocol, String host, int port, String file, String ref) {
        super.setURL(url, protocol, host, port, null, null, file, null, ref);
    }

    protected synchronized String toExternalForm(URL url) {
        URLStreamHandlerService svc = this.getStreamHandlerService();
        if (svc == null) {
            throw new IllegalStateException("Unknown protocol: " + url.getProtocol());
        }
        return svc.toExternalForm(url);
    }

    private URLStreamHandlerService getStreamHandlerService() {
        Object framework = URLHandlers.getFrameworkFromContext();
        if (framework == null) {
            return null;
        }
        Object tracker = this.m_trackerMap.get(framework);
        try {
            Object service;
            if (tracker == null) {
                String filter = "(&(objectClass=" + (class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = URLHandlersStreamHandlerProxy.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService).getName() + ")(" + "url.handler.protocol" + "=" + this.m_protocol + "))";
                tracker = this.m_action.invoke(this.m_action.getConstructor(framework.getClass().getClassLoader().loadClass((class$org$apache$felix$framework$URLHandlersServiceTracker == null ? (class$org$apache$felix$framework$URLHandlersServiceTracker = URLHandlersStreamHandlerProxy.class$("org.apache.felix.framework.URLHandlersServiceTracker")) : class$org$apache$felix$framework$URLHandlersServiceTracker).getName()), new Class[]{framework.getClass(), class$java$lang$String == null ? (class$java$lang$String = URLHandlersStreamHandlerProxy.class$("java.lang.String")) : class$java$lang$String}), new Object[]{framework, filter});
                this.m_trackerMap.put(framework, tracker);
            }
            if ((service = this.m_action.invoke(this.m_action.getMethod(tracker.getClass(), "getService", null), tracker, null)) == null) {
                return null;
            }
            if (service instanceof URLStreamHandlerService) {
                return (URLStreamHandlerService)service;
            }
            return (URLStreamHandlerService)Proxy.newProxyInstance((class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = URLHandlersStreamHandlerProxy.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService).getClassLoader(), new Class[]{class$org$osgi$service$url$URLStreamHandlerService == null ? (class$org$osgi$service$url$URLStreamHandlerService = URLHandlersStreamHandlerProxy.class$("org.osgi.service.url.URLStreamHandlerService")) : class$org$osgi$service$url$URLStreamHandlerService}, (InvocationHandler)new URLHandlersStreamHandlerProxy(service, this.m_action));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public Object invoke(Object obj, Method method, Object[] params) throws Throwable {
        Class[] types = method.getParameterTypes();
        if ("parseURL".equals(method.getName())) {
            types[0] = this.m_service.getClass().getClassLoader().loadClass((class$org$osgi$service$url$URLStreamHandlerSetter == null ? (class$org$osgi$service$url$URLStreamHandlerSetter = URLHandlersStreamHandlerProxy.class$("org.osgi.service.url.URLStreamHandlerSetter")) : class$org$osgi$service$url$URLStreamHandlerSetter).getName());
            params[0] = Proxy.newProxyInstance(this.m_service.getClass().getClassLoader(), new Class[]{types[0]}, (InvocationHandler)((URLHandlersStreamHandlerProxy)params[0]));
        }
        return this.m_action.invoke(this.m_action.getMethod(this.m_service.getClass(), method.getName(), types), this.m_service, params);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

